/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.edc.spi.types.domain.DataAddress;

@JsonTypeName
@JsonDeserialize(builder=DataAddress.Builder.class)
public class HttpDataAddress
extends DataAddress {
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String QUERY_PARAMS = "queryParams";
    private static final String METHOD = "method";
    private static final String AUTH_KEY = "authKey";
    private static final String AUTH_CODE = "authCode";
    private static final String SECRET_NAME = "secretName";
    @Deprecated(since="0.12.0")
    private static final String PROXY_BODY = "proxyBody";
    @Deprecated(since="0.12.0")
    private static final String PROXY_PATH = "proxyPath";
    @Deprecated(since="0.12.0")
    private static final String PROXY_QUERY_PARAMS = "proxyQueryParams";
    @Deprecated(since="0.12.0")
    private static final String PROXY_METHOD = "proxyMethod";
    public static final String ADDITIONAL_HEADER = "header:";
    public static final String CONTENT_TYPE = "contentType";
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String NON_CHUNKED_TRANSFER = "nonChunkedTransfer";
    public static final Set<String> ADDITIONAL_HEADERS_TO_IGNORE = Set.of("content-type");

    private HttpDataAddress() {
        this.setType("HttpData");
    }

    @JsonIgnore
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @JsonIgnore
    public String getBaseUrl() {
        return this.getStringProperty("https://w3id.org/edc/v0.0.1/ns/baseUrl");
    }

    @JsonIgnore
    public String getPath() {
        return this.getStringProperty(PATH);
    }

    @JsonIgnore
    public String getQueryParams() {
        return this.getStringProperty(QUERY_PARAMS);
    }

    @JsonIgnore
    public String getMethod() {
        return this.getStringProperty(METHOD);
    }

    @JsonIgnore
    public String getAuthKey() {
        return this.getStringProperty(AUTH_KEY);
    }

    @JsonIgnore
    public String getAuthCode() {
        return this.getStringProperty(AUTH_CODE);
    }

    @JsonIgnore
    public String getSecretName() {
        return this.getStringProperty(SECRET_NAME);
    }

    @JsonIgnore
    @Deprecated(since="0.12.0")
    public String getProxyBody() {
        return this.getStringProperty(PROXY_BODY);
    }

    @JsonIgnore
    @Deprecated(since="0.12.0")
    public String getProxyPath() {
        return this.getStringProperty(PROXY_PATH);
    }

    @JsonIgnore
    @Deprecated(since="0.12.0")
    public String getProxyQueryParams() {
        return this.getStringProperty(PROXY_QUERY_PARAMS);
    }

    @JsonIgnore
    @Deprecated(since="0.12.0")
    public String getProxyMethod() {
        return this.getStringProperty(PROXY_METHOD);
    }

    @JsonIgnore
    public String getContentType() {
        return this.getStringProperty(CONTENT_TYPE, OCTET_STREAM);
    }

    @JsonIgnore
    public Map<String, String> getAdditionalHeaders() {
        return this.getProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(ADDITIONAL_HEADER)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).replace(ADDITIONAL_HEADER, ""), it -> (String)it.getValue()));
    }

    @JsonIgnore
    public boolean getNonChunkedTransfer() {
        return Optional.of(NON_CHUNKED_TRANSFER).map(arg_0 -> ((HttpDataAddress)this).getStringProperty(arg_0)).map(Boolean::parseBoolean).orElse(false);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder
    extends DataAddress.Builder<HttpDataAddress, Builder> {
        private Builder() {
            super((DataAddress)new HttpDataAddress());
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder name(String name) {
            this.property(HttpDataAddress.NAME, name);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.property("https://w3id.org/edc/v0.0.1/ns/baseUrl", baseUrl);
            return this;
        }

        public Builder path(String path) {
            this.property(HttpDataAddress.PATH, path);
            return this;
        }

        public Builder queryParams(String queryParams) {
            this.property(HttpDataAddress.QUERY_PARAMS, queryParams);
            return this;
        }

        public Builder method(String method) {
            this.property(HttpDataAddress.METHOD, method);
            return this;
        }

        public Builder authKey(String authKey) {
            this.property(HttpDataAddress.AUTH_KEY, authKey);
            return this;
        }

        public Builder authCode(String authCode) {
            this.property(HttpDataAddress.AUTH_CODE, authCode);
            return this;
        }

        public Builder secretName(String secretName) {
            this.property(HttpDataAddress.SECRET_NAME, secretName);
            return this;
        }

        @Deprecated(since="0.12.0")
        public Builder proxyBody(String proxyBody) {
            this.property(HttpDataAddress.PROXY_BODY, proxyBody);
            return this;
        }

        @Deprecated(since="0.12.0")
        public Builder proxyPath(String proxyPath) {
            this.property(HttpDataAddress.PROXY_PATH, proxyPath);
            return this;
        }

        @Deprecated(since="0.12.0")
        public Builder proxyQueryParams(String proxyQueryParams) {
            this.property(HttpDataAddress.PROXY_QUERY_PARAMS, proxyQueryParams);
            return this;
        }

        @Deprecated(since="0.12.0")
        public Builder proxyMethod(String proxyMethod) {
            this.property(HttpDataAddress.PROXY_METHOD, proxyMethod);
            return this;
        }

        public Builder addAdditionalHeader(String additionalHeaderName, String additionalHeaderValue) {
            if (ADDITIONAL_HEADERS_TO_IGNORE.contains(additionalHeaderName.toLowerCase())) {
                return this;
            }
            ((HttpDataAddress)this.address).getProperties().put(HttpDataAddress.ADDITIONAL_HEADER + additionalHeaderName, Objects.requireNonNull(additionalHeaderValue));
            return this;
        }

        public Builder contentType(String contentType) {
            this.property(HttpDataAddress.CONTENT_TYPE, contentType);
            return this;
        }

        public Builder nonChunkedTransfer(boolean nonChunkedTransfer) {
            this.property(HttpDataAddress.NON_CHUNKED_TRANSFER, String.valueOf(nonChunkedTransfer));
            return this;
        }

        public Builder copyFrom(DataAddress other) {
            Optional.ofNullable(other).map(DataAddress::getProperties).orElse(Collections.emptyMap()).forEach((arg_0, arg_1) -> ((Builder)this).property(arg_0, arg_1));
            return this;
        }

        public HttpDataAddress build() {
            this.type("HttpData");
            return (HttpDataAddress)this.address;
        }
    }
}

