/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.http.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpRequestParams {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final boolean DEFAULT_NON_CHUNKED_TRANSFER = false;
    private String method;
    private String baseUrl;
    private String path;
    private String queryParams;
    private String contentType = "application/octet-stream";
    private String body;
    private boolean nonChunkedTransfer = false;
    private final Map<String, String> headers = new HashMap<String, String>();

    public String getMethod() {
        return this.method;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isNonChunkedTransfer() {
        return this.nonChunkedTransfer;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private final HttpRequestParams params = new HttpRequestParams();

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder baseUrl(String baseUrl) {
            this.params.baseUrl = baseUrl;
            return this;
        }

        public Builder queryParams(String queryParams) {
            this.params.queryParams = queryParams;
            return this;
        }

        public Builder method(String method) {
            this.params.method = method;
            return this;
        }

        public Builder header(String key, String value) {
            this.params.headers.put(key, value);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.params.headers.putAll(headers);
            return this;
        }

        public Builder contentType(String contentType) {
            this.params.contentType = contentType;
            return this;
        }

        public Builder body(String body) {
            this.params.body = body;
            return this;
        }

        public Builder path(String path) {
            this.params.path = path;
            return this;
        }

        public Builder nonChunkedTransfer(boolean nonChunkedTransfer) {
            this.params.nonChunkedTransfer = nonChunkedTransfer;
            return this;
        }

        public HttpRequestParams build() {
            this.params.headers.forEach((s, s2) -> Objects.requireNonNull(s2, "value for header: " + s));
            Objects.requireNonNull(this.params.baseUrl, "baseUrl");
            Objects.requireNonNull(this.params.method, "method");
            Objects.requireNonNull(this.params.contentType, "contentType");
            this.params.headers.forEach((s, s2) -> Objects.requireNonNull(s2, "value for header: " + s));
            return this.params;
        }
    }
}

