/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.api.controller;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.eclipse.edc.connector.dataplane.api.controller.DataPlaneControlApi;
import org.eclipse.edc.connector.dataplane.spi.DataFlowStates;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.connector.dataplane.spi.response.TransferErrorResponse;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;

@Path(value="/transfer")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DataPlaneControlApiController
implements DataPlaneControlApi {
    private final DataPlaneManager dataPlaneManager;

    public DataPlaneControlApiController(DataPlaneManager dataPlaneManager) {
        this.dataPlaneManager = dataPlaneManager;
    }

    @Override
    @POST
    public void initiateTransfer(DataFlowStartMessage request, @Suspended AsyncResponse response) {
        Result result = this.dataPlaneManager.validate(request);
        if (result.succeeded()) {
            this.dataPlaneManager.start(request);
            response.resume((Object)Response.ok().build());
        } else {
            Response resp = result.getFailureMessages().isEmpty() ? this.badRequest(String.format("Failed to validate request: %s", request.getId())) : this.badRequest(result.getFailureMessages());
            response.resume((Object)resp);
        }
    }

    @Override
    @GET
    @Path(value="/{transferProcessId}")
    public DataFlowStates getTransferState(@PathParam(value="transferProcessId") String transferProcessId) {
        return this.dataPlaneManager.getTransferState(transferProcessId);
    }

    @Override
    @DELETE
    @Path(value="/{transferProcessId}")
    public void terminateTransfer(@PathParam(value="transferProcessId") String transferProcessId, @Suspended AsyncResponse response) {
        ((StatusResult)this.dataPlaneManager.terminate(transferProcessId).onSuccess(r -> response.resume((Object)Response.noContent().build()))).onFailure(f -> response.resume((Object)this.badRequest(List.of("Cannot terminate transfer: " + f.getFailureDetail()))));
    }

    private Response badRequest(String error) {
        return this.badRequest(List.of(error));
    }

    private Response badRequest(List<String> errors) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new TransferErrorResponse(errors)).build();
    }
}

