/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.api.controller;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.container.AsyncResponse;
import org.eclipse.edc.connector.dataplane.spi.DataFlowStates;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;

@OpenAPIDefinition
@Tag(name="Data Plane control API", description="Api targeted by the Control Plane to delegate a data transfer (Provider Push or Streaming) to the Data Plane after the contract has been successfully negotiated and agreed between the two participants. ")
public interface DataPlaneControlApi {
    @Operation(description="Initiates a data transfer for the given request. The transfer will be performed asynchronously.", responses={@ApiResponse(responseCode="400", description="Failed to validate request"), @ApiResponse(responseCode="200", description="Data transfer initiated")})
    public void initiateTransfer(DataFlowStartMessage var1, AsyncResponse var2);

    @Operation(description="Get the current state of a data transfer.", responses={@ApiResponse(responseCode="200", description="Missing access token")})
    public DataFlowStates getTransferState(String var1);

    @Operation(description="Terminates a data transfer.", responses={@ApiResponse(responseCode="204", description="Data transfer terminated"), @ApiResponse(responseCode="404", description="Data transfer not handled by the data plane"), @ApiResponse(responseCode="409", description="Cannot terminate the transfer")})
    public void terminateTransfer(String var1, AsyncResponse var2);
}

