/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import java.util.Objects;
import org.eclipse.edc.connector.dataplane.client.EmbeddedDataPlaneClient;
import org.eclipse.edc.connector.dataplane.client.RemoteDataPlaneClient;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClientFactory;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Data Plane Client")
public class DataPlaneClientExtension
implements ServiceExtension {
    public static final String NAME = "Data Plane Client";
    @Inject(required=false)
    private DataPlaneManager dataPlaneManager;
    @Inject(required=false)
    private EdcHttpClient httpClient;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    @Provider
    public DataPlaneClientFactory dataPlaneClientFactory(ServiceExtensionContext context) {
        if (this.dataPlaneManager != null) {
            context.getMonitor().debug(() -> "Using embedded Data Plane client.", new Throwable[0]);
            return instance -> new EmbeddedDataPlaneClient(this.dataPlaneManager);
        }
        context.getMonitor().debug(() -> "Using remote Data Plane client.", new Throwable[0]);
        Objects.requireNonNull(this.httpClient, "To use remote Data Plane client, an EdcHttpClient instance must be registered");
        return instance -> new RemoteDataPlaneClient(this.httpClient, this.typeManager.getMapper(), instance);
    }
}

