/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.IOException;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.dataplane.spi.response.TransferErrorResponse;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;

public class RemoteDataPlaneClient
implements DataPlaneClient {
    public static final MediaType TYPE_JSON = MediaType.parse((String)"application/json");
    private final EdcHttpClient httpClient;
    private final ObjectMapper mapper;
    private final DataPlaneInstance dataPlane;

    public RemoteDataPlaneClient(EdcHttpClient httpClient, ObjectMapper mapper, DataPlaneInstance dataPlane) {
        this.httpClient = httpClient;
        this.mapper = mapper;
        this.dataPlane = dataPlane;
    }

    @WithSpan
    public StatusResult<Void> transfer(DataFlowRequest dataFlowRequest) {
        StatusResult<Void> statusResult;
        block10: {
            RequestBody body;
            try {
                body = RequestBody.create((String)this.mapper.writeValueAsString((Object)dataFlowRequest), (MediaType)TYPE_JSON);
            }
            catch (JsonProcessingException e) {
                throw new EdcException((Throwable)e);
            }
            Request request = new Request.Builder().post(body).url(this.dataPlane.getUrl()).build();
            Response response = this.httpClient.execute(request);
            try {
                statusResult = this.handleResponse(response, dataFlowRequest.getId());
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)e.getMessage());
                }
            }
            response.close();
        }
        return statusResult;
    }

    public StatusResult<Void> terminate(String transferProcessId) {
        StatusResult<Void> statusResult;
        block8: {
            Request request = new Request.Builder().delete().url(this.dataPlane.getUrl() + "/" + transferProcessId).build();
            Response response = this.httpClient.execute(request);
            try {
                statusResult = this.handleResponse(response, transferProcessId);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)e.getMessage());
                }
            }
            response.close();
        }
        return statusResult;
    }

    private StatusResult<Void> handleResponse(Response response, String requestId) {
        if (response.isSuccessful()) {
            return StatusResult.success();
        }
        return this.handleError(response, requestId);
    }

    private StatusResult<Void> handleError(Response response, String requestId) {
        String errorMsg = Optional.ofNullable(response.body()).map(this::formatErrorMessage).orElse("null response body");
        return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Transfer request failed with status code %s for request %s: %s", response.code(), requestId, errorMsg));
    }

    private String formatErrorMessage(ResponseBody body) {
        try {
            TransferErrorResponse errorResponse = (TransferErrorResponse)this.mapper.readValue(body.string(), TransferErrorResponse.class);
            return String.join((CharSequence)", ", errorResponse.getErrors());
        }
        catch (IOException e) {
            return "failed to read response body";
        }
    }
}

