/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneSelectorClient;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.dataplane.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.dataplane.spi.response.TransferErrorResponse;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;

public class RemoteDataPlaneClient
implements DataPlaneClient {
    public static final MediaType TYPE_JSON = MediaType.parse((String)"application/json");
    private final DataPlaneSelectorClient selectorClient;
    private final String selectorStrategy;
    private final EdcHttpClient httpClient;
    private final ObjectMapper mapper;

    public RemoteDataPlaneClient(EdcHttpClient httpClient, DataPlaneSelectorClient selectorClient, String selectorStrategy, ObjectMapper mapper) {
        this.selectorClient = Objects.requireNonNull(selectorClient, "Data plane selector client");
        this.selectorStrategy = Objects.requireNonNull(selectorStrategy, "Selector strategy");
        this.httpClient = Objects.requireNonNull(httpClient, "Http client");
        this.mapper = Objects.requireNonNull(mapper, "Object mapper");
    }

    @WithSpan
    public StatusResult<Void> transfer(DataFlowRequest request) {
        StatusResult<Void> statusResult;
        block11: {
            RequestBody body;
            DataPlaneInstance instance = this.selectorClient.find(request.getSourceDataAddress(), request.getDestinationDataAddress(), this.selectorStrategy);
            if (instance == null) {
                return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to find data plane instance supporting request: " + request.getId()));
            }
            try {
                body = RequestBody.create((String)this.mapper.writeValueAsString((Object)request), (MediaType)TYPE_JSON);
            }
            catch (JsonProcessingException e) {
                throw new EdcException((Throwable)e);
            }
            Request rq = new Request.Builder().post(body).url(instance.getUrl()).build();
            Response response = this.httpClient.execute(rq);
            try {
                statusResult = this.handleResponse(response, request.getId());
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)e.getMessage());
                }
            }
            response.close();
        }
        return statusResult;
    }

    private StatusResult<Void> handleResponse(Response response, String requestId) {
        if (response.isSuccessful()) {
            return StatusResult.success();
        }
        return this.handleError(response, requestId);
    }

    private StatusResult<Void> handleError(Response response, String requestId) {
        String errorMsg = Optional.ofNullable(response.body()).map(this::formatErrorMessage).orElse("null response body");
        return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Transfer request failed with status code %s for request %s: %s", response.code(), requestId, errorMsg));
    }

    private String formatErrorMessage(ResponseBody body) {
        try {
            TransferErrorResponse errorResponse = (TransferErrorResponse)this.mapper.readValue(body.string(), TransferErrorResponse.class);
            return String.join((CharSequence)", ", errorResponse.getErrors());
        }
        catch (IOException e) {
            return "failed to read response body";
        }
    }
}

