/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.client;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Objects;
import org.eclipse.edc.connector.dataplane.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.dataplane.spi.manager.DataPlaneManager;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;

public class EmbeddedDataPlaneClient
implements DataPlaneClient {
    private final DataPlaneManager dataPlaneManager;

    public EmbeddedDataPlaneClient(DataPlaneManager dataPlaneManager) {
        this.dataPlaneManager = Objects.requireNonNull(dataPlaneManager, "Data plane manager");
    }

    @WithSpan
    public StatusResult<Void> transfer(DataFlowRequest request) {
        Result result = this.dataPlaneManager.validate(request);
        if (result.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.join((CharSequence)", ", result.getFailureMessages()));
        }
        this.dataPlaneManager.initiateTransfer(request);
        return StatusResult.success();
    }
}

