/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.azure.storage.pipeline;

import dev.failsafe.RetryPolicy;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.azure.blob.validator.AzureStorageValidator;
import org.eclipse.edc.connector.dataplane.azure.storage.pipeline.AzureStorageDataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class AzureStorageDataSourceFactory
implements DataSourceFactory {
    private final BlobStoreApi blobStoreApi;
    private final RetryPolicy<Object> retryPolicy;
    private final Monitor monitor;
    private final Vault vault;

    public AzureStorageDataSourceFactory(BlobStoreApi blobStoreApi, RetryPolicy<Object> retryPolicy, Monitor monitor, Vault vault) {
        this.blobStoreApi = blobStoreApi;
        this.retryPolicy = retryPolicy;
        this.monitor = monitor;
        this.vault = vault;
    }

    public boolean canHandle(DataFlowRequest request) {
        return "AzureStorage".equals(request.getSourceDataAddress().getType());
    }

    @NotNull
    public Result<Boolean> validate(DataFlowRequest request) {
        return this.validateRequest(request).mapTo();
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        DataAddress dataAddress = request.getSourceDataAddress();
        try {
            AzureStorageValidator.validateAccountName((String)dataAddress.getProperty("account"));
            AzureStorageValidator.validateContainerName((String)dataAddress.getProperty("container"));
            AzureStorageValidator.validateBlobName((String)dataAddress.getProperty("blobname"));
            AzureStorageValidator.validateKeyName((String)dataAddress.getKeyName());
        }
        catch (IllegalArgumentException e) {
            return Result.failure((String)("AzureStorage source address is invalid: " + e.getMessage()));
        }
        return VALID.mapTo();
    }

    public DataSource createSource(DataFlowRequest request) {
        this.validateRequest(request).orElseThrow(f -> new EdcException(f.getFailureDetail()));
        DataAddress dataAddress = request.getSourceDataAddress();
        return AzureStorageDataSource.Builder.newInstance().accountName(dataAddress.getProperty("account")).containerName(dataAddress.getProperty("container")).sharedKey(this.vault.resolveSecret(dataAddress.getKeyName())).blobStoreApi(this.blobStoreApi).blobName(dataAddress.getProperty("blobname")).requestId(request.getId()).retryPolicy(this.retryPolicy).monitor(this.monitor).build();
    }
}

