/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.azure.storage.pipeline;

import dev.failsafe.RetryPolicy;
import java.io.InputStream;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.edc.azure.blob.adapter.BlobAdapter;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;

public class AzureStorageDataSource
implements DataSource {
    private String accountName;
    private String containerName;
    private String sharedKey;
    private String blobName;
    private String requestId;
    private RetryPolicy<Object> retryPolicy;
    private BlobStoreApi blobStoreApi;
    private Monitor monitor;

    public StreamResult<Stream<DataSource.Part>> openPartStream() {
        return StreamResult.success(Stream.of(this.getPart()));
    }

    private AzureStoragePart getPart() {
        try {
            BlobAdapter adapter = this.blobStoreApi.getBlobAdapter(this.accountName, this.containerName, this.blobName, this.sharedKey);
            return new AzureStoragePart(adapter);
        }
        catch (Exception e) {
            this.monitor.severe(String.format("Error accessing blob %s on account %s", this.blobName, this.accountName), new Throwable[]{e});
            throw new EdcException((Throwable)e);
        }
    }

    private AzureStorageDataSource() {
    }

    private static class AzureStoragePart
    implements DataSource.Part {
        private final BlobAdapter adapter;

        AzureStoragePart(BlobAdapter adapter) {
            this.adapter = adapter;
        }

        public String name() {
            return this.adapter.getBlobName();
        }

        public long size() {
            return this.adapter.getBlobSize();
        }

        public InputStream openStream() {
            return this.adapter.openInputStream();
        }
    }

    public static class Builder {
        private AzureStorageDataSource dataSource = new AzureStorageDataSource();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder accountName(String accountName) {
            this.dataSource.accountName = accountName;
            return this;
        }

        public Builder containerName(String containerName) {
            this.dataSource.containerName = containerName;
            return this;
        }

        public Builder sharedKey(String sharedKey) {
            this.dataSource.sharedKey = sharedKey;
            return this;
        }

        public Builder blobName(String blobName) {
            this.dataSource.blobName = blobName;
            return this;
        }

        public Builder requestId(String requestId) {
            this.dataSource.requestId = requestId;
            return this;
        }

        public Builder retryPolicy(RetryPolicy<Object> retryPolicy) {
            this.dataSource.retryPolicy = retryPolicy;
            return this;
        }

        public Builder blobStoreApi(BlobStoreApi blobStoreApi) {
            this.dataSource.blobStoreApi = blobStoreApi;
            return this;
        }

        public Builder monitor(Monitor monitor) {
            this.dataSource.monitor = monitor;
            return this;
        }

        public AzureStorageDataSource build() {
            Objects.requireNonNull(this.dataSource.accountName, "accountName");
            Objects.requireNonNull(this.dataSource.containerName, "containerName");
            Objects.requireNonNull(this.dataSource.sharedKey, "sharedKey");
            Objects.requireNonNull(this.dataSource.requestId, "requestId");
            Objects.requireNonNull(this.dataSource.blobStoreApi, "blobStoreApi");
            Objects.requireNonNull(this.dataSource.monitor, "monitor");
            Objects.requireNonNull(this.dataSource.retryPolicy, "retryPolicy");
            return this.dataSource;
        }
    }
}

