/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.azure.storage.pipeline;

import java.util.concurrent.ExecutorService;
import org.eclipse.edc.azure.blob.AzureSasToken;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.azure.blob.validator.AzureStorageValidator;
import org.eclipse.edc.connector.dataplane.azure.storage.pipeline.AzureStorageDataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class AzureStorageDataSinkFactory
implements DataSinkFactory {
    private final BlobStoreApi blobStoreApi;
    private final ExecutorService executorService;
    private final int partitionSize;
    private final Monitor monitor;
    private final Vault vault;
    private final TypeManager typeManager;

    public AzureStorageDataSinkFactory(BlobStoreApi blobStoreApi, ExecutorService executorService, int partitionSize, Monitor monitor, Vault vault, TypeManager typeManager) {
        this.blobStoreApi = blobStoreApi;
        this.executorService = executorService;
        this.partitionSize = partitionSize;
        this.monitor = monitor;
        this.vault = vault;
        this.typeManager = typeManager;
    }

    public boolean canHandle(DataFlowRequest request) {
        return "AzureStorage".equals(request.getDestinationDataAddress().getType());
    }

    @NotNull
    public Result<Boolean> validate(DataFlowRequest request) {
        return this.validateRequest(request).mapTo();
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        DataAddress dataAddress = request.getDestinationDataAddress();
        try {
            AzureStorageValidator.validateAccountName((String)dataAddress.getProperty("account"));
            AzureStorageValidator.validateContainerName((String)dataAddress.getProperty("container"));
            AzureStorageValidator.validateKeyName((String)dataAddress.getKeyName());
        }
        catch (IllegalArgumentException e) {
            return Result.failure((String)("AzureStorage destination address is invalid: " + e.getMessage()));
        }
        return VALID.mapTo();
    }

    public DataSink createSink(DataFlowRequest request) {
        Result<Void> validate = this.validateRequest(request);
        if (validate.failed()) {
            throw new EdcException(validate.getFailure().getMessages().toString());
        }
        DataAddress dataAddress = request.getDestinationDataAddress();
        String requestId = request.getId();
        String secret = this.vault.resolveSecret(dataAddress.getKeyName());
        AzureSasToken token = (AzureSasToken)this.typeManager.readValue(secret, AzureSasToken.class);
        return ((AzureStorageDataSink.Builder)((AzureStorageDataSink.Builder)((AzureStorageDataSink.Builder)((AzureStorageDataSink.Builder)AzureStorageDataSink.Builder.newInstance().accountName(dataAddress.getProperty("account")).containerName(dataAddress.getProperty("container")).sharedAccessSignature(token.getSas()).requestId(requestId)).partitionSize(this.partitionSize)).blobStoreApi(this.blobStoreApi).executorService(this.executorService)).monitor(this.monitor)).build();
    }
}

