/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.azure.storage.pipeline;

import com.azure.core.credential.AzureSasCredential;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.connector.dataplane.util.sink.ParallelSink;
import org.jetbrains.annotations.NotNull;

public class AzureStorageDataSink
extends ParallelSink {
    public static final String COMPLETE_BLOB_NAME = ".complete";
    private String accountName;
    private String containerName;
    private String sharedAccessSignature;
    private BlobStoreApi blobStoreApi;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StreamResult<Void> transferParts(List<DataSource.Part> parts) {
        Iterator<DataSource.Part> iterator = parts.iterator();
        while (iterator.hasNext()) {
            DataSource.Part part = iterator.next();
            String blobName = part.name();
            try {
                InputStream input = part.openStream();
                try {
                    OutputStream output = this.blobStoreApi.getBlobAdapter(this.accountName, this.containerName, blobName, new AzureSasCredential(this.sharedAccessSignature)).getOutputStream();
                    try {
                        input.transferTo(output);
                    }
                    catch (Exception e) {
                        StreamResult<Void> streamResult = this.getTransferResult(e, "Error transferring blob for %s on account %s", blobName, this.accountName);
                        if (output != null) {
                            output.close();
                        }
                        if (input == null) return streamResult;
                        input.close();
                        return streamResult;
                    }
                    {
                        catch (Throwable throwable) {
                            if (output == null) throw throwable;
                            try {
                                output.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    if (output == null) continue;
                    output.close();
                }
                catch (Exception e) {
                    StreamResult<Void> streamResult = this.getTransferResult(e, "Error creating blob for %s on account %s", blobName, this.accountName);
                    return streamResult;
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (Exception e) {
                return this.getTransferResult(e, "Error reading blob %s", blobName);
            }
        }
        return StreamResult.success();
    }

    protected StreamResult<Void> complete() {
        try {
            this.blobStoreApi.getBlobAdapter(this.accountName, this.containerName, COMPLETE_BLOB_NAME, new AzureSasCredential(this.sharedAccessSignature)).getOutputStream().close();
        }
        catch (Exception e) {
            return this.getTransferResult(e, "Error creating blob %s on account %s", COMPLETE_BLOB_NAME, this.accountName);
        }
        return super.complete();
    }

    @NotNull
    private StreamResult<Void> getTransferResult(Exception e, String logMessage, Object ... args) {
        String message = String.format(logMessage, args);
        this.monitor.severe(message, new Throwable[]{e});
        return StreamResult.error((String)message);
    }

    private AzureStorageDataSink() {
    }

    public static class Builder
    extends ParallelSink.Builder<Builder, AzureStorageDataSink> {
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder accountName(String accountName) {
            ((AzureStorageDataSink)this.sink).accountName = accountName;
            return this;
        }

        public Builder containerName(String containerName) {
            ((AzureStorageDataSink)this.sink).containerName = containerName;
            return this;
        }

        public Builder sharedAccessSignature(String sharedAccessSignature) {
            ((AzureStorageDataSink)this.sink).sharedAccessSignature = sharedAccessSignature;
            return this;
        }

        public Builder blobStoreApi(BlobStoreApi blobStoreApi) {
            ((AzureStorageDataSink)this.sink).blobStoreApi = blobStoreApi;
            return this;
        }

        protected void validate() {
            Objects.requireNonNull(((AzureStorageDataSink)this.sink).accountName, "accountName");
            Objects.requireNonNull(((AzureStorageDataSink)this.sink).containerName, "containerName");
            Objects.requireNonNull(((AzureStorageDataSink)this.sink).sharedAccessSignature, "sharedAccessSignature");
            Objects.requireNonNull(((AzureStorageDataSink)this.sink).blobStoreApi, "blobStoreApi");
        }

        private Builder() {
            super((ParallelSink)new AzureStorageDataSink());
        }
    }
}

