/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.azure.storage;

import dev.failsafe.RetryPolicy;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.connector.dataplane.azure.storage.pipeline.AzureStorageDataSinkFactory;
import org.eclipse.edc.connector.dataplane.azure.storage.pipeline.AzureStorageDataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataTransferExecutorServiceContainer;
import org.eclipse.edc.connector.dataplane.spi.pipeline.PipelineService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Data Plane Azure Storage")
public class DataPlaneAzureStorageExtension
implements ServiceExtension {
    public static final String NAME = "Data Plane Azure Storage";
    @Inject
    private RetryPolicy retryPolicy;
    @Inject
    private PipelineService pipelineService;
    @Inject
    private BlobStoreApi blobStoreApi;
    @Inject
    private DataTransferExecutorServiceContainer executorContainer;
    @Inject
    private Vault vault;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        AzureStorageDataSourceFactory sourceFactory = new AzureStorageDataSourceFactory(this.blobStoreApi, (RetryPolicy<Object>)this.retryPolicy, monitor, this.vault);
        this.pipelineService.registerFactory((DataSourceFactory)sourceFactory);
        AzureStorageDataSinkFactory sinkFactory = new AzureStorageDataSinkFactory(this.blobStoreApi, this.executorContainer.getExecutorService(), 5, monitor, this.vault, this.typeManager);
        this.pipelineService.registerFactory((DataSinkFactory)sinkFactory);
    }
}

