/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.util.Optional;
import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.aws.s3.AwsSecretToken;
import org.eclipse.edc.aws.s3.AwsTemporarySecretToken;
import org.eclipse.edc.aws.s3.S3ClientRequest;
import org.eclipse.edc.aws.s3.validation.S3DataAddressCredentialsValidator;
import org.eclipse.edc.aws.s3.validation.S3SourceDataAddressValidator;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.SecretToken;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.util.string.StringUtils;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.jetbrains.annotations.NotNull;

public class S3DataSourceFactory
implements DataSourceFactory {
    private final Validator<DataAddress> validation = new S3SourceDataAddressValidator();
    private final Validator<DataAddress> credentialsValidation = new S3DataAddressCredentialsValidator();
    private final AwsClientProvider clientProvider;
    private final Monitor monitor;
    private final Vault vault;
    private final TypeManager typeManager;

    public S3DataSourceFactory(AwsClientProvider clientProvider, Monitor monitor, Vault vault, TypeManager typeManager) {
        this.clientProvider = clientProvider;
        this.monitor = monitor;
        this.vault = vault;
        this.typeManager = typeManager;
    }

    public String supportedType() {
        return "AmazonS3";
    }

    public boolean canHandle(DataFlowStartMessage request) {
        return "AmazonS3".equals(request.getSourceDataAddress().getType());
    }

    public DataSource createSource(DataFlowStartMessage request) {
        Result<Void> validationResult = this.validateRequest(request);
        if (validationResult.failed()) {
            throw new EdcException(String.join((CharSequence)", ", validationResult.getFailureMessages()));
        }
        DataAddress source = request.getSourceDataAddress();
        S3ClientRequest s3ClientRequest = this.createS3ClientRequest(source);
        return S3DataSource.Builder.newInstance().bucketName(source.getStringProperty("bucketName")).keyName(source.getKeyName()).objectName(source.getStringProperty("objectName")).keyPrefix(source.getStringProperty("keyPrefix")).objectPrefix(source.getStringProperty("objectPrefix")).client(this.clientProvider.s3Client(s3ClientRequest)).monitor(this.monitor).build();
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowStartMessage request) {
        DataAddress source = request.getSourceDataAddress();
        return (Result)this.validation.validate((Object)source).flatMap(ValidationResult::toResult);
    }

    private S3ClientRequest createS3ClientRequest(DataAddress address) {
        String endpointOverride = address.getStringProperty("endpointOverride");
        String region = address.getStringProperty("region");
        Optional<AwsTemporarySecretToken> awsSecretToken = Optional.ofNullable(address.getKeyName()).filter(keyName -> !StringUtils.isNullOrBlank((String)keyName)).map(arg_0 -> ((Vault)this.vault).resolveSecret(arg_0)).filter(secret -> !StringUtils.isNullOrBlank((String)secret)).map(s -> (AwsTemporarySecretToken)this.typeManager.readValue(s, AwsTemporarySecretToken.class));
        if (awsSecretToken.isPresent()) {
            return S3ClientRequest.from((String)region, (String)endpointOverride, (SecretToken)((SecretToken)awsSecretToken.get()));
        }
        if (this.credentialsValidation.validate((Object)address).succeeded()) {
            String accessKeyId = address.getStringProperty("accessKeyId");
            String secretAccessKey = address.getStringProperty("secretAccessKey");
            return S3ClientRequest.from((String)region, (String)endpointOverride, (SecretToken)new AwsSecretToken(accessKeyId, secretAccessKey));
        }
        return S3ClientRequest.from((String)region, (String)endpointOverride);
    }
}

