/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.aws.s3.AwsSecretToken;
import org.eclipse.edc.aws.s3.AwsTemporarySecretToken;
import org.eclipse.edc.aws.s3.S3ClientRequest;
import org.eclipse.edc.aws.s3.validation.S3DataAddressCredentialsValidator;
import org.eclipse.edc.aws.s3.validation.S3DestinationDataAddressValidator;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.SecretToken;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.util.string.StringUtils;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.jetbrains.annotations.NotNull;

public class S3DataSinkFactory
implements DataSinkFactory {
    private final Validator<DataAddress> validation = new S3DestinationDataAddressValidator();
    private final Validator<DataAddress> credentialsValidation = new S3DataAddressCredentialsValidator();
    private final AwsClientProvider clientProvider;
    private final ExecutorService executorService;
    private final Monitor monitor;
    private final Vault vault;
    private final TypeManager typeManager;
    private final int chunkSizeInBytes;

    public S3DataSinkFactory(AwsClientProvider clientProvider, ExecutorService executorService, Monitor monitor, Vault vault, TypeManager typeManager, int chunkSizeInBytes) {
        this.clientProvider = clientProvider;
        this.executorService = executorService;
        this.monitor = monitor;
        this.vault = vault;
        this.typeManager = typeManager;
        this.chunkSizeInBytes = chunkSizeInBytes;
    }

    public String supportedType() {
        return "AmazonS3";
    }

    public boolean canHandle(DataFlowStartMessage request) {
        return "AmazonS3".equals(request.getDestinationDataAddress().getType());
    }

    public DataSink createSink(DataFlowStartMessage request) {
        Result<Void> validationResult = this.validateRequest(request);
        if (validationResult.failed()) {
            throw new EdcException(String.join((CharSequence)", ", validationResult.getFailureMessages()));
        }
        DataAddress destination = request.getDestinationDataAddress();
        S3ClientRequest s3ClientRequest = this.createS3ClientRequest(destination);
        return ((S3DataSink.Builder)((S3DataSink.Builder)((S3DataSink.Builder)S3DataSink.Builder.newInstance().bucketName(destination.getStringProperty("bucketName")).keyName(destination.getKeyName()).objectName(destination.getStringProperty("objectName")).folderName(destination.getStringProperty("folderName")).requestId(request.getId())).executorService(this.executorService)).monitor(this.monitor)).client(this.clientProvider.s3Client(s3ClientRequest)).chunkSizeBytes(this.chunkSizeInBytes).build();
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowStartMessage request) {
        DataAddress destination = request.getDestinationDataAddress();
        return (Result)this.validation.validate((Object)destination).flatMap(ValidationResult::toResult);
    }

    private S3ClientRequest createS3ClientRequest(DataAddress address) {
        String endpointOverride = address.getStringProperty("endpointOverride");
        String region = address.getStringProperty("region");
        Optional<AwsTemporarySecretToken> awsSecretToken = Optional.ofNullable(address.getKeyName()).filter(keyName -> !StringUtils.isNullOrBlank((String)keyName)).map(arg_0 -> ((Vault)this.vault).resolveSecret(arg_0)).filter(secret -> !StringUtils.isNullOrBlank((String)secret)).map(s -> (AwsTemporarySecretToken)this.typeManager.readValue(s, AwsTemporarySecretToken.class));
        if (awsSecretToken.isPresent()) {
            return S3ClientRequest.from((String)region, (String)endpointOverride, (SecretToken)((SecretToken)awsSecretToken.get()));
        }
        if (this.credentialsValidation.validate((Object)address).succeeded()) {
            String accessKeyId = address.getStringProperty("accessKeyId");
            String secretAccessKey = address.getStringProperty("secretAccessKey");
            return S3ClientRequest.from((String)region, (String)endpointOverride, (SecretToken)new AwsSecretToken(accessKeyId, secretAccessKey));
        }
        return S3ClientRequest.from((String)region, (String)endpointOverride);
    }
}

