/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.connector.dataplane.aws.s3.exceptions.S3DataSourceException;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.connector.dataplane.util.sink.ParallelSink;
import org.eclipse.edc.util.string.StringUtils;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

class S3DataSink
extends ParallelSink {
    private S3Client client;
    private String bucketName;
    @Deprecated(since="0.5.2")
    private String keyName;
    private String objectName;
    private String folderName;
    private int chunkSize;

    private S3DataSink() {
    }

    protected StreamResult<Object> transferParts(List<DataSource.Part> parts) {
        for (DataSource.Part part : parts) {
            String key = this.getDestinationObjectName(part.name(), parts.size());
            try {
                InputStream input = part.openStream();
                try {
                    ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
                    String uploadId = this.client.createMultipartUpload((CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucketName).key(key).build()).uploadId();
                    int partNumber = 1;
                    byte[] bytesChunk = input.readNBytes(this.chunkSize);
                    while (bytesChunk.length > 0) {
                        completedParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(partNumber)).eTag(this.client.uploadPart((UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(key).uploadId(uploadId).partNumber(Integer.valueOf(partNumber)).build(), RequestBody.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytesChunk))).eTag()).build());
                        bytesChunk = input.readNBytes(this.chunkSize);
                        ++partNumber;
                    }
                    this.client.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucketName).key(key).uploadId(uploadId).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build()).build());
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (S3DataSourceException e) {
                return this.transferFailure((Exception)((Object)e), "download", key);
            }
            catch (Exception e) {
                return this.transferFailure(e, "upload", key);
            }
        }
        return StreamResult.success();
    }

    private String getDestinationObjectName(String partName, int partsSize) {
        String name;
        String string = name = partsSize == 1 && !StringUtils.isNullOrEmpty((String)this.objectName) ? this.objectName : partName;
        if (!StringUtils.isNullOrEmpty((String)this.folderName)) {
            return this.folderName.endsWith("/") ? this.folderName + name : this.folderName + "/" + name;
        }
        return name;
    }

    @NotNull
    private StreamResult<Object> transferFailure(Exception e, String operation, String objectKeyName) {
        String message = "Failed to %s the %s object: %s".formatted(operation, objectKeyName, e.getMessage());
        this.monitor.severe(message, new Throwable[]{e});
        return StreamResult.error((String)message);
    }

    public static class Builder
    extends ParallelSink.Builder<Builder, S3DataSink> {
        private Builder() {
            super((ParallelSink)new S3DataSink());
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder client(S3Client client) {
            ((S3DataSink)this.sink).client = client;
            return this;
        }

        public Builder bucketName(String bucketName) {
            ((S3DataSink)this.sink).bucketName = bucketName;
            return this;
        }

        public Builder keyName(String keyName) {
            ((S3DataSink)this.sink).keyName = keyName;
            return this;
        }

        public Builder objectName(String objectName) {
            ((S3DataSink)this.sink).objectName = objectName;
            return this;
        }

        public Builder folderName(String folderName) {
            ((S3DataSink)this.sink).folderName = folderName;
            return this;
        }

        public Builder chunkSizeBytes(int chunkSize) {
            ((S3DataSink)this.sink).chunkSize = chunkSize;
            return this;
        }

        protected void validate() {
        }
    }
}

