/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.aws.s3.AwsSecretToken;
import org.eclipse.edc.aws.s3.S3ClientRequest;
import org.eclipse.edc.aws.s3.validation.S3DataAddressCredentialsValidator;
import org.eclipse.edc.aws.s3.validation.S3DataAddressValidator;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.transfer.spi.types.SecretToken;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.s3.S3Client;

public class S3DataSourceFactory
implements DataSourceFactory {
    private final Validator<DataAddress> validation = new S3DataAddressValidator();
    private final Validator<DataAddress> credentialsValidation = new S3DataAddressCredentialsValidator();
    private final AwsClientProvider clientProvider;
    private final Vault vault;
    private final TypeManager typeManager;

    public S3DataSourceFactory(AwsClientProvider clientProvider, Vault vault, TypeManager typeManager) {
        this.clientProvider = clientProvider;
        this.vault = vault;
        this.typeManager = typeManager;
    }

    public boolean canHandle(DataFlowRequest request) {
        return "AmazonS3".equals(request.getSourceDataAddress().getType());
    }

    public DataSource createSource(DataFlowRequest request) {
        Result<Void> validationResult = this.validateRequest(request);
        if (validationResult.failed()) {
            throw new EdcException(String.join((CharSequence)", ", validationResult.getFailureMessages()));
        }
        DataAddress source = request.getSourceDataAddress();
        return S3DataSource.Builder.newInstance().bucketName(source.getStringProperty("bucketName")).keyName(source.getKeyName()).keyPrefix(source.getStringProperty("keyPrefix")).client(this.getS3Client(source)).build();
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        DataAddress source = request.getSourceDataAddress();
        return (Result)this.validation.validate((Object)source).flatMap(ValidationResult::toResult);
    }

    private S3Client getS3Client(DataAddress address) {
        S3Client client;
        String endpointOverride = address.getStringProperty("endpointOverride");
        String secret = this.vault.resolveSecret(address.getKeyName());
        if (secret != null) {
            AwsSecretToken secretToken = (AwsSecretToken)this.typeManager.readValue(secret, AwsSecretToken.class);
            client = this.clientProvider.s3Client(S3ClientRequest.from((String)address.getStringProperty("region"), (String)endpointOverride, (SecretToken)secretToken));
        } else if (this.credentialsValidation.validate((Object)address).succeeded()) {
            AwsSecretToken secretToken = new AwsSecretToken(address.getStringProperty("accessKeyId"), address.getStringProperty("secretAccessKey"));
            client = this.clientProvider.s3Client(S3ClientRequest.from((String)address.getStringProperty("region"), (String)endpointOverride, (SecretToken)secretToken));
        } else {
            client = this.clientProvider.s3Client(S3ClientRequest.from((String)address.getStringProperty("region"), (String)endpointOverride));
        }
        return client;
    }
}

