/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import org.eclipse.edc.connector.dataplane.util.sink.ParallelSink;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

class S3DataSink
extends ParallelSink {
    private S3Client client;
    private String bucketName;
    private String keyName;
    private int chunkSize;

    private S3DataSink() {
    }

    protected StreamResult<Object> transferParts(List<DataSource.Part> parts) {
        for (DataSource.Part part : parts) {
            try {
                InputStream input = part.openStream();
                try {
                    byte[] bytesChunk;
                    int partNumber = 1;
                    ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
                    String uploadId = this.client.createMultipartUpload((CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucketName).key(part.name()).build()).uploadId();
                    while ((bytesChunk = input.readNBytes(this.chunkSize)).length >= 1) {
                        completedParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(partNumber)).eTag(this.client.uploadPart((UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(this.keyName).uploadId(uploadId).partNumber(Integer.valueOf(partNumber)).build(), RequestBody.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytesChunk))).eTag()).build());
                        ++partNumber;
                    }
                    this.client.completeMultipartUpload((CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucketName).key(this.keyName).uploadId(uploadId).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build()).build());
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (Exception e) {
                return this.uploadFailure(e, this.keyName);
            }
        }
        return StreamResult.success();
    }

    protected StreamResult<Object> complete() {
        String completeKeyName = this.keyName + ".complete";
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(completeKeyName).build();
        try {
            this.client.putObject(request, RequestBody.empty());
            return super.complete();
        }
        catch (Exception e) {
            return this.uploadFailure(e, completeKeyName);
        }
    }

    @NotNull
    private StreamResult<Object> uploadFailure(Exception e, String keyName) {
        String message = String.format("Error writing the %s object on the %s bucket: %s", keyName, this.bucketName, e.getMessage());
        this.monitor.severe(message, new Throwable[]{e});
        return StreamResult.error((String)message);
    }

    public static class Builder
    extends ParallelSink.Builder<Builder, S3DataSink> {
        private Builder() {
            super((ParallelSink)new S3DataSink());
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder client(S3Client client) {
            ((S3DataSink)this.sink).client = client;
            return this;
        }

        public Builder bucketName(String bucketName) {
            ((S3DataSink)this.sink).bucketName = bucketName;
            return this;
        }

        public Builder keyName(String keyName) {
            ((S3DataSink)this.sink).keyName = keyName;
            return this;
        }

        public Builder chunkSizeBytes(int chunkSize) {
            ((S3DataSink)this.sink).chunkSize = chunkSize;
            return this;
        }

        protected void validate() {
        }
    }
}

