/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.io.InputStream;
import java.util.stream.Stream;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.StreamResult;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;

class S3DataSource
implements DataSource {
    private String bucketName;
    private String keyName;
    private S3Client client;

    private S3DataSource() {
    }

    public StreamResult<Stream<DataSource.Part>> openPartStream() {
        return StreamResult.success(Stream.of(new S3Part(this.client, this.keyName, this.bucketName)));
    }

    private static class S3Part
    implements DataSource.Part {
        private final S3Client client;
        private final String keyName;
        private final String bucketName;

        S3Part(S3Client client, String keyName, String bucketName) {
            this.client = client;
            this.keyName = keyName;
            this.bucketName = bucketName;
        }

        public String name() {
            return this.keyName;
        }

        public long size() {
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().key(this.keyName).bucket(this.bucketName).build();
            return this.client.headObject(request).contentLength();
        }

        public InputStream openStream() {
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().key(this.keyName).bucket(this.bucketName).build();
            return this.client.getObject(request);
        }
    }

    public static class Builder {
        private final S3DataSource source = new S3DataSource();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder bucketName(String bucketName) {
            this.source.bucketName = bucketName;
            return this;
        }

        public Builder keyName(String keyName) {
            this.source.keyName = keyName;
            return this;
        }

        public Builder client(S3Client client) {
            this.source.client = client;
            return this;
        }

        public S3DataSource build() {
            return this.source;
        }
    }
}

