/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.util.concurrent.ExecutorService;
import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.aws.s3.AwsSecretToken;
import org.eclipse.edc.aws.s3.AwsTemporarySecretToken;
import org.eclipse.edc.aws.s3.S3ClientRequest;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSink;
import org.eclipse.edc.connector.dataplane.aws.s3.validation.S3DataAddressCredentialsValidationRule;
import org.eclipse.edc.connector.dataplane.aws.s3.validation.S3DataAddressValidationRule;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSink;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.util.validation.ValidationRule;
import org.eclipse.edc.connector.transfer.spi.types.SecretToken;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.s3.S3Client;

public class S3DataSinkFactory
implements DataSinkFactory {
    private static final int CHUNK_SIZE_IN_BYTES = 524288000;
    private final ValidationRule<DataAddress> validation = new S3DataAddressValidationRule();
    private final ValidationRule<DataAddress> credentialsValidation = new S3DataAddressCredentialsValidationRule();
    private final AwsClientProvider clientProvider;
    private final ExecutorService executorService;
    private final Monitor monitor;
    private final Vault vault;
    private final TypeManager typeManager;

    public S3DataSinkFactory(AwsClientProvider clientProvider, ExecutorService executorService, Monitor monitor, Vault vault, TypeManager typeManager) {
        this.clientProvider = clientProvider;
        this.executorService = executorService;
        this.monitor = monitor;
        this.vault = vault;
        this.typeManager = typeManager;
    }

    public boolean canHandle(DataFlowRequest request) {
        return "AmazonS3".equals(request.getDestinationDataAddress().getType());
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        DataAddress destination = request.getDestinationDataAddress();
        return (Result)((Result)this.validation.apply((Object)destination)).map(it -> null);
    }

    public DataSink createSink(DataFlowRequest request) {
        Result<Void> validationResult = this.validateRequest(request);
        if (validationResult.failed()) {
            throw new EdcException(String.join((CharSequence)", ", validationResult.getFailureMessages()));
        }
        DataAddress destination = request.getDestinationDataAddress();
        S3Client client = this.createS3Client(destination);
        return ((S3DataSink.Builder)((S3DataSink.Builder)((S3DataSink.Builder)S3DataSink.Builder.newInstance().bucketName(destination.getStringProperty("bucketName")).keyName(destination.getKeyName()).requestId(request.getId())).executorService(this.executorService)).monitor(this.monitor)).client(client).chunkSizeBytes(524288000).build();
    }

    private S3Client createS3Client(DataAddress destination) {
        S3Client client;
        String endpointOverride = destination.getStringProperty("endpointOverride");
        String secret = this.vault.resolveSecret(destination.getKeyName());
        if (secret != null) {
            AwsTemporarySecretToken secretToken = (AwsTemporarySecretToken)this.typeManager.readValue(secret, AwsTemporarySecretToken.class);
            client = this.clientProvider.s3Client(S3ClientRequest.from((String)destination.getStringProperty("region"), (String)endpointOverride, (SecretToken)secretToken));
        } else if (((Result)this.credentialsValidation.apply((Object)destination)).succeeded()) {
            AwsSecretToken secretToken = new AwsSecretToken(destination.getStringProperty("accessKeyId"), destination.getStringProperty("secretAccessKey"));
            client = this.clientProvider.s3Client(S3ClientRequest.from((String)destination.getStringProperty("region"), (String)endpointOverride, (SecretToken)secretToken));
        } else {
            client = this.clientProvider.s3Client(S3ClientRequest.from((String)destination.getStringProperty("region"), (String)endpointOverride));
        }
        return client;
    }
}

