/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSinkFactory;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSinkFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.dataplane.spi.pipeline.PipelineService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Data Plane S3 Storage")
public class DataPlaneS3Extension
implements ServiceExtension {
    public static final String NAME = "Data Plane S3 Storage";
    @Inject
    private PipelineService pipelineService;
    @Inject
    private AwsClientProvider awsClientProvider;
    @Inject
    private Vault vault;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Monitor monitor = context.getMonitor();
        S3DataSourceFactory sourceFactory = new S3DataSourceFactory(this.awsClientProvider, this.vault, this.typeManager);
        this.pipelineService.registerFactory((DataSourceFactory)sourceFactory);
        S3DataSinkFactory sinkFactory = new S3DataSinkFactory(this.awsClientProvider, executorService, monitor, this.vault, this.typeManager);
        this.pipelineService.registerFactory((DataSinkFactory)sinkFactory);
    }
}

