/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.aws.s3;

import org.eclipse.edc.aws.s3.AwsClientProvider;
import org.eclipse.edc.aws.s3.AwsSecretToken;
import org.eclipse.edc.connector.dataplane.aws.s3.S3DataSource;
import org.eclipse.edc.connector.dataplane.aws.s3.validation.S3DataAddressCredentialsValidationRule;
import org.eclipse.edc.connector.dataplane.aws.s3.validation.S3DataAddressValidationRule;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSource;
import org.eclipse.edc.connector.dataplane.spi.pipeline.DataSourceFactory;
import org.eclipse.edc.connector.dataplane.util.validation.ValidationRule;
import org.eclipse.edc.connector.transfer.spi.types.SecretToken;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.s3.S3Client;

public class S3DataSourceFactory
implements DataSourceFactory {
    private final ValidationRule<DataAddress> validation = new S3DataAddressValidationRule();
    private final ValidationRule<DataAddress> credentialsValidation = new S3DataAddressCredentialsValidationRule();
    private final AwsClientProvider clientProvider;
    private final Vault vault;
    private final TypeManager typeManager;

    public S3DataSourceFactory(AwsClientProvider clientProvider, Vault vault, TypeManager typeManager) {
        this.clientProvider = clientProvider;
        this.vault = vault;
        this.typeManager = typeManager;
    }

    public boolean canHandle(DataFlowRequest request) {
        return "AmazonS3".equals(request.getSourceDataAddress().getType());
    }

    @NotNull
    public Result<Boolean> validate(DataFlowRequest request) {
        return (Result)this.validateRequest(request).map(it -> true);
    }

    @NotNull
    public Result<Void> validateRequest(DataFlowRequest request) {
        DataAddress source = request.getSourceDataAddress();
        return (Result)((Result)this.validation.apply((Object)source)).map(it -> null);
    }

    public DataSource createSource(DataFlowRequest request) {
        S3Client client;
        Result<Void> validationResult = this.validateRequest(request);
        if (validationResult.failed()) {
            throw new EdcException(String.join((CharSequence)", ", validationResult.getFailureMessages()));
        }
        DataAddress source = request.getSourceDataAddress();
        String secret = this.vault.resolveSecret(source.getKeyName());
        if (secret != null) {
            AwsSecretToken secretToken = (AwsSecretToken)this.typeManager.readValue(secret, AwsSecretToken.class);
            client = this.clientProvider.s3Client(source.getProperty("region"), (SecretToken)secretToken);
        } else if (((Result)this.credentialsValidation.apply((Object)source)).succeeded()) {
            AwsSecretToken secretToken = new AwsSecretToken(source.getProperty("accessKeyId"), source.getProperty("secretAccessKey"));
            client = this.clientProvider.s3Client(source.getProperty("region"), (SecretToken)secretToken);
        } else {
            client = this.clientProvider.s3Client(source.getProperty("region"));
        }
        return S3DataSource.Builder.newInstance().bucketName(source.getProperty("bucketName")).keyName(source.getKeyName()).client(client).build();
    }
}

