/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.security.token.jwt;

import com.nimbusds.jose.JWSSigner;
import org.eclipse.edc.jwt.signer.spi.JwsSignerProvider;
import org.eclipse.edc.keys.spi.PrivateKeyResolver;
import org.eclipse.edc.security.token.jwt.CryptoConverter;
import org.eclipse.edc.spi.result.Result;

public class DefaultJwsSignerProvider
implements JwsSignerProvider {
    private final PrivateKeyResolver privateKeyResolver;

    public DefaultJwsSignerProvider(PrivateKeyResolver privateKeyResolver) {
        this.privateKeyResolver = privateKeyResolver;
    }

    public Result<JWSSigner> createJwsSigner(String privateKeyId) {
        return (Result)this.privateKeyResolver.resolvePrivateKey(privateKeyId).compose(pk -> Result.ofThrowable(() -> CryptoConverter.createSignerFor(pk)));
    }
}

