/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.identityhub.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.runtime.metamodel.annotation.Configuration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Settings;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.apiversion.ApiVersionService;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.configuration.PortMapping;
import org.eclipse.edc.web.spi.configuration.PortMappingRegistry;

@Extension(value="Storage API Extension")
public class CredentialsApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Storage API Extension";
    private static final String API_VERSION_JSON_FILE = "credentials-api-version.json";
    @Configuration
    private CredentialsApiConfiguration apiConfiguration;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeManager typeManager;
    @Inject
    private ApiVersionService apiVersionService;
    @Inject
    private PortMappingRegistry portMappingRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.portMappingRegistry.register(new PortMapping("credentials", this.apiConfiguration.port(), this.apiConfiguration.path()));
        this.jsonLd.registerContext("https://w3id.org/dspace-dcp/v1.0/dcp.jsonld", "dcp-api:v1.0");
        this.registerVersionInfo(this.getClass().getClassLoader());
    }

    private void registerVersionInfo(ClassLoader resourceClassLoader) {
        try (InputStream versionContent = resourceClassLoader.getResourceAsStream(API_VERSION_JSON_FILE);){
            if (versionContent == null) {
                throw new EdcException("Version file not found or not readable.");
            }
            Stream.of((VersionRecord[])this.typeManager.getMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(versionContent, VersionRecord[].class)).forEach(vr -> this.apiVersionService.addRecord("credentials", vr));
        }
        catch (IOException e) {
            throw new EdcException((Throwable)e);
        }
    }

    @Settings
    record CredentialsApiConfiguration(@Setting(key="web.http.credentials.port", description="Port for credentials api context", defaultValue="13131") int port, @Setting(key="web.http.credentials.path", description="Path for credentials api context", defaultValue="/api/credentials") String path) {
    }
}

