/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.crawler.spi.model;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.edc.crawler.spi.model.ExecutionPlan;
import org.eclipse.edc.spi.monitor.Monitor;

public class RecurringExecutionPlan
implements ExecutionPlan {
    private final Duration schedule;
    private final Duration withInitialDelay;
    private final Monitor monitor;

    public RecurringExecutionPlan(Duration schedule, Duration initialDelay, Monitor monitor) {
        this.schedule = schedule;
        this.withInitialDelay = initialDelay;
        this.monitor = monitor;
    }

    @Override
    public void run(Runnable task) {
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor();
        ses.scheduleAtFixedRate(this.catchExceptions(task), this.withInitialDelay.toMillis(), this.schedule.toMillis(), TimeUnit.MILLISECONDS);
    }

    private Runnable catchExceptions(Runnable original) {
        return () -> {
            try {
                original.run();
            }
            catch (Throwable thr) {
                this.monitor.severe("Unexpected error during plan execution", new Throwable[]{thr});
            }
        };
    }
}

