/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transform.odrl.to;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.AndConstraint;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.Constraint;
import org.eclipse.edc.policy.model.Expression;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.policy.model.MultiplicityConstraint;
import org.eclipse.edc.policy.model.Operator;
import org.eclipse.edc.policy.model.OrConstraint;
import org.eclipse.edc.policy.model.XoneConstraint;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToConstraintTransformer
extends AbstractJsonLdTransformer<JsonObject, Constraint> {
    private final Map<String, Supplier<MultiplicityConstraint.Builder<?, ?>>> operands = Map.of("http://www.w3.org/ns/odrl/2/and", AndConstraint.Builder::newInstance, "http://www.w3.org/ns/odrl/2/or", OrConstraint.Builder::newInstance, "http://www.w3.org/ns/odrl/2/xone", XoneConstraint.Builder::newInstance);

    public JsonObjectToConstraintTransformer() {
        super(JsonObject.class, Constraint.class);
    }

    @Nullable
    public Constraint transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        MultiplicityConstraint logicalConstraint = this.transformLogicalConstraint(object, context);
        if (logicalConstraint != null) {
            return logicalConstraint;
        }
        return this.transformAtomicConstraint(object, context);
    }

    private AtomicConstraint transformAtomicConstraint(@NotNull JsonObject object, @NotNull TransformerContext context) {
        AtomicConstraint.Builder builder = AtomicConstraint.Builder.newInstance();
        if (!this.transformMandatoryString((JsonValue)object.get((Object)"http://www.w3.org/ns/odrl/2/leftOperand"), s -> builder.leftExpression((Expression)new LiteralExpression(s)), context)) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("http://www.w3.org/ns/odrl/2/Constraint")).property("http://www.w3.org/ns/odrl/2/leftOperand")).report();
            return null;
        }
        JsonValue jsonOperator = (JsonValue)object.get((Object)"http://www.w3.org/ns/odrl/2/operator");
        if (jsonOperator == null) {
            ((MissingPropertyBuilder)((MissingPropertyBuilder)context.problem().missingProperty().type("http://www.w3.org/ns/odrl/2/Constraint")).property("http://www.w3.org/ns/odrl/2/operator")).report();
            return null;
        }
        builder.operator((Operator)this.transformObject(jsonOperator, Operator.class, context));
        Object rightOperand = this.extractComplexValue((JsonValue)object.get((Object)"http://www.w3.org/ns/odrl/2/rightOperand"));
        builder.rightExpression((Expression)new LiteralExpression(rightOperand));
        return (AtomicConstraint)this.builderResult(() -> ((AtomicConstraint.Builder)builder).build(), context);
    }

    @Nullable
    private MultiplicityConstraint transformLogicalConstraint(@NotNull JsonObject object, @NotNull TransformerContext context) {
        return this.operands.entrySet().stream().filter(entry -> object.containsKey(entry.getKey())).findFirst().map(entry -> {
            MultiplicityConstraint.Builder builder = ((MultiplicityConstraint.Builder)((Supplier)entry.getValue()).get()).constraints(this.transformArray((JsonValue)object.get(entry.getKey()), Constraint.class, context));
            return (MultiplicityConstraint)this.builderResult(() -> ((MultiplicityConstraint.Builder)builder).build(), context);
        }).orElse(null);
    }

    private Object extractComplexValue(JsonValue root) {
        switch (root.getValueType()) {
            case ARRAY: {
                JsonArray array = root.asJsonArray();
                if (array.size() != 1) {
                    return array;
                }
                return this.extractComplexValue((JsonValue)array.get(0));
            }
            case OBJECT: {
                JsonValue valueProp = (JsonValue)root.asJsonObject().get((Object)"@value");
                if (valueProp == null) break;
                return this.extractValue(valueProp);
            }
            default: {
                return this.extractValue(root);
            }
        }
        return this.extractValue(root);
    }

    private Object extractValue(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case NUMBER: {
                return ((JsonNumber)value).numberValue();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return value;
    }
}

