/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transform.edc.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.function.BiConsumer;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.jsonld.spi.TypeUtil;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToAssetTransformer
extends AbstractJsonLdTransformer<JsonObject, Asset> {
    public JsonObjectToAssetTransformer() {
        super(JsonObject.class, Asset.class);
    }

    @Nullable
    public Asset transform(@NotNull JsonObject jsonObject, @NotNull TransformerContext context) {
        Asset.Builder builder = Asset.Builder.newInstance().id(this.nodeId((JsonValue)jsonObject));
        this.visitProperties(jsonObject, key -> switch (key) {
            case "https://w3id.org/edc/v0.0.1/ns/properties" -> value -> this.visitProperties(value.asJsonArray().getJsonObject(0), this.property(context, builder));
            case "https://w3id.org/edc/v0.0.1/ns/privateProperties" -> value -> this.visitProperties(value.asJsonArray().getJsonObject(0), this.privateProperty(context, builder));
            case "https://w3id.org/edc/v0.0.1/ns/dataAddress" -> value -> builder.dataAddress((DataAddress)this.transformObject((JsonValue)value, DataAddress.class, context));
            default -> JsonObjectToAssetTransformer.doNothing();
        });
        if ("https://w3id.org/edc/v0.0.1/ns/CatalogAsset".equals(TypeUtil.nodeType((JsonObject)jsonObject))) {
            builder.property("https://w3id.org/edc/v0.0.1/ns/isCatalog", (Object)true);
        }
        return (Asset)this.builderResult(() -> ((Asset.Builder)builder).build(), context);
    }

    @NotNull
    private BiConsumer<String, JsonValue> privateProperty(@NotNull TransformerContext context, Asset.Builder builder) {
        return (k, val) -> builder.privateProperty(k, this.transformGenericProperty((JsonValue)val, context));
    }

    @NotNull
    private BiConsumer<String, JsonValue> property(@NotNull TransformerContext context, Asset.Builder builder) {
        return (k, val) -> builder.property(k, this.transformGenericProperty((JsonValue)val, context));
    }
}

