/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transform.edc.from;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectFromAssetTransformer
extends AbstractJsonLdTransformer<Asset, JsonObject> {
    private final TypeManager typeManager;
    private final String typeContext;
    private final JsonBuilderFactory jsonFactory;

    public JsonObjectFromAssetTransformer(JsonBuilderFactory jsonFactory, TypeManager typeManager, String typeContext) {
        super(Asset.class, JsonObject.class);
        this.jsonFactory = jsonFactory;
        this.typeManager = typeManager;
        this.typeContext = typeContext;
    }

    @Nullable
    public JsonObject transform(@NotNull Asset asset, @NotNull TransformerContext context) {
        JsonObjectBuilder builder = this.jsonFactory.createObjectBuilder().add("@id", asset.getId()).add("@type", "https://w3id.org/edc/v0.0.1/ns/Asset");
        JsonObjectBuilder propBuilder = this.jsonFactory.createObjectBuilder();
        this.transformProperties(asset.getProperties(), propBuilder, this.typeManager.getMapper(this.typeContext), context);
        builder.add("https://w3id.org/edc/v0.0.1/ns/properties", propBuilder);
        if (asset.getPrivateProperties() != null && !asset.getPrivateProperties().isEmpty()) {
            JsonObjectBuilder privatePropBuilder = this.jsonFactory.createObjectBuilder();
            this.transformProperties(asset.getPrivateProperties(), privatePropBuilder, this.typeManager.getMapper(this.typeContext), context);
            builder.add("https://w3id.org/edc/v0.0.1/ns/privateProperties", privatePropBuilder);
        }
        if (asset.isCatalog()) {
            builder.add("@type", "https://w3id.org/edc/v0.0.1/ns/CatalogAsset");
        }
        if (asset.getDataAddress() != null) {
            builder.add("https://w3id.org/edc/v0.0.1/ns/dataAddress", (JsonValue)context.transform((Object)asset.getDataAddress(), JsonObject.class));
        }
        return builder.build();
    }
}

