/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transform.odrl.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.participant.spi.ParticipantIdMapper;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.policy.model.PolicyType;
import org.eclipse.edc.policy.model.Prohibition;
import org.eclipse.edc.transform.spi.InvalidPropertyBuilder;
import org.eclipse.edc.transform.spi.MissingPropertyBuilder;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToPolicyTransformer
extends AbstractJsonLdTransformer<JsonObject, Policy> {
    private final ParticipantIdMapper participantIdMapper;

    public JsonObjectToPolicyTransformer(ParticipantIdMapper participantIdMapper) {
        super(JsonObject.class, Policy.class);
        this.participantIdMapper = participantIdMapper;
    }

    @Nullable
    public Policy transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        Policy.Builder builder = Policy.Builder.newInstance();
        PolicyType policyType = Optional.ofNullable(context.consumeData(Policy.class, "@type")).map(PolicyType.class::cast).orElseGet(() -> {
            String tp;
            return switch (tp = object.getJsonArray("@type").stream().findFirst().map(JsonString.class::cast).map(JsonString::getString).orElse("http://www.w3.org/ns/odrl/2/Set")) {
                case "http://www.w3.org/ns/odrl/2/Set" -> PolicyType.SET;
                case "http://www.w3.org/ns/odrl/2/Offer" -> PolicyType.OFFER;
                case "http://www.w3.org/ns/odrl/2/Agreement" -> PolicyType.CONTRACT;
                default -> null;
            };
        });
        if (policyType == null) {
            ((InvalidPropertyBuilder)context.problem().invalidProperty().property("@type")).value(null).error("Invalid type for ODRL policy, should be one of [%s, %s, %s]".formatted("http://www.w3.org/ns/odrl/2/Set", "http://www.w3.org/ns/odrl/2/Offer", "http://www.w3.org/ns/odrl/2/Agreement")).report();
            return null;
        }
        if (policyType == PolicyType.CONTRACT) {
            if (object.get((Object)"http://www.w3.org/ns/odrl/2/assignee") == null) {
                ((MissingPropertyBuilder)context.problem().missingProperty().property("http://www.w3.org/ns/odrl/2/assignee")).report();
                return null;
            }
            if (object.get((Object)"http://www.w3.org/ns/odrl/2/assigner") == null) {
                ((MissingPropertyBuilder)context.problem().missingProperty().property("http://www.w3.org/ns/odrl/2/assigner")).report();
                return null;
            }
        }
        builder.type(policyType);
        this.visitProperties(object, key -> switch (key) {
            case "http://www.w3.org/ns/odrl/2/permission" -> v -> builder.permissions(this.transformArray((JsonValue)v, Permission.class, context));
            case "http://www.w3.org/ns/odrl/2/prohibition" -> v -> builder.prohibitions(this.transformArray((JsonValue)v, Prohibition.class, context));
            case "http://www.w3.org/ns/odrl/2/obligation" -> v -> builder.duties(this.transformArray((JsonValue)v, Duty.class, context));
            case "http://www.w3.org/ns/odrl/2/target" -> v -> builder.target(this.transformString((JsonValue)v, context));
            case "http://www.w3.org/ns/odrl/2/assigner" -> v -> builder.assigner(this.participantIdMapper.fromIri(this.transformString((JsonValue)v, context)));
            case "http://www.w3.org/ns/odrl/2/assignee" -> v -> builder.assignee(this.participantIdMapper.fromIri(this.transformString((JsonValue)v, context)));
            case "http://www.w3.org/ns/odrl/2/profile" -> v -> builder.profiles(this.transformProfile((JsonValue)v));
            default -> v -> builder.extensibleProperty(key, this.transformGenericProperty((JsonValue)v, context));
        });
        return (Policy)this.builderResult(() -> ((Policy.Builder)builder).build(), context);
    }

    private List<String> transformProfile(JsonValue value) {
        return value.asJsonArray().stream().map(x$0 -> this.nodeId((JsonValue)x$0)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

