/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transform.odrl.to;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Optional;
import org.eclipse.edc.jsonld.spi.transformer.AbstractJsonLdTransformer;
import org.eclipse.edc.policy.model.Action;
import org.eclipse.edc.policy.model.Constraint;
import org.eclipse.edc.transform.spi.TransformerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonObjectToActionTransformer
extends AbstractJsonLdTransformer<JsonObject, Action> {
    public JsonObjectToActionTransformer() {
        super(JsonObject.class, Action.class);
    }

    @Nullable
    public Action transform(@NotNull JsonObject object, @NotNull TransformerContext context) {
        Action.Builder builder = Action.Builder.newInstance();
        String type = Optional.ofNullable(this.nodeId((JsonValue)object)).orElseGet(() -> this.nodeValue((JsonValue)object));
        builder.type(type);
        this.visitProperties(object, (key, value) -> this.transformProperties((String)key, (JsonValue)value, builder, context));
        return (Action)this.builderResult(() -> ((Action.Builder)builder).build(), context);
    }

    private void transformProperties(String key, JsonValue value, Action.Builder builder, TransformerContext context) {
        if ("http://www.w3.org/ns/odrl/2/type".equals(key)) {
            this.transformString(value, arg_0 -> ((Action.Builder)builder).type(arg_0), context);
        } else if ("http://www.w3.org/ns/odrl/2/action".equals(key)) {
            this.transformString(value, arg_0 -> ((Action.Builder)builder).type(arg_0), context);
        } else if ("http://www.w3.org/ns/odrl/2/includedIn".equals(key)) {
            this.transformString(value, arg_0 -> ((Action.Builder)builder).includedIn(arg_0), context);
        } else if ("http://www.w3.org/ns/odrl/2/refinement".equals(key)) {
            this.transformArrayOrObject(value, Constraint.class, arg_0 -> ((Action.Builder)builder).constraint(arg_0), context);
        }
    }
}

