/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.validation;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.connector.controlplane.asset.spi.index.AssetIndex;
import org.eclipse.edc.connector.controlplane.contract.policy.PolicyEquality;
import org.eclipse.edc.connector.controlplane.contract.spi.ContractOfferId;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ValidatableConsumerOffer;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ValidatedConsumerOffer;
import org.eclipse.edc.policy.engine.spi.PolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyContextImpl;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.agent.ParticipantAgent;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.result.Result;
import org.jetbrains.annotations.NotNull;

public class ContractValidationServiceImpl
implements ContractValidationService {
    private final AssetIndex assetIndex;
    private final PolicyEngine policyEngine;
    private final PolicyEquality policyEquality;

    public ContractValidationServiceImpl(AssetIndex assetIndex, PolicyEngine policyEngine, PolicyEquality policyEquality) {
        this.assetIndex = assetIndex;
        this.policyEngine = policyEngine;
        this.policyEquality = policyEquality;
    }

    @NotNull
    public Result<ValidatedConsumerOffer> validateInitialOffer(ParticipantAgent agent, ValidatableConsumerOffer consumerOffer) {
        return (Result)((Result)this.validateInitialOffer(consumerOffer, agent).compose(policy -> this.createContractOffer((Policy)policy, consumerOffer.getOfferId()))).map(contractOffer -> new ValidatedConsumerOffer(agent.getIdentity(), contractOffer));
    }

    @NotNull
    public Result<ContractAgreement> validateAgreement(ParticipantAgent agent, ContractAgreement agreement) {
        String consumerIdentity = agent.getIdentity();
        if (consumerIdentity == null || !consumerIdentity.equals(agreement.getConsumerId())) {
            return Result.failure((String)"Invalid provider credentials");
        }
        PolicyContext policyContext = PolicyContextImpl.Builder.newInstance().additional(ParticipantAgent.class, (Object)agent).additional(ContractAgreement.class, (Object)agreement).additional(Instant.class, (Object)Instant.now()).build();
        Result policyResult = this.policyEngine.evaluate("transfer.process", agreement.getPolicy(), policyContext);
        if (!policyResult.succeeded()) {
            return Result.failure((String)String.format("Policy does not fulfill the agreement %s, policy evaluation %s", agreement.getId(), policyResult.getFailureDetail()));
        }
        return Result.success((Object)agreement);
    }

    @NotNull
    public Result<Void> validateRequest(ParticipantAgent agent, ContractAgreement agreement) {
        return Optional.ofNullable(agent.getIdentity()).filter(id -> id.equals(agreement.getConsumerId()) || id.equals(agreement.getProviderId())).map(id -> Result.success()).orElse(Result.failure((String)"Invalid counter-party identity"));
    }

    @NotNull
    public Result<Void> validateRequest(ParticipantAgent agent, ContractNegotiation negotiation) {
        String counterPartyIdentity = agent.getIdentity();
        return counterPartyIdentity != null && counterPartyIdentity.equals(negotiation.getCounterPartyId()) ? Result.success() : Result.failure((String)"Invalid counter-party identity");
    }

    @NotNull
    public Result<Void> validateConfirmed(ParticipantAgent agent, ContractAgreement agreement, ContractOffer latestOffer) {
        if (!Objects.equals(agent.getIdentity(), agreement.getProviderId())) {
            return Result.failure((String)"Invalid provider credentials");
        }
        if (latestOffer == null) {
            return Result.failure((String)"No offer found");
        }
        if (!this.policyEquality.test(agreement.getPolicy().withTarget(latestOffer.getAssetId()), latestOffer.getPolicy())) {
            return Result.failure((String)"Policy in the contract agreement is not equal to the one in the contract offer");
        }
        return Result.success();
    }

    private Result<Policy> validateInitialOffer(ValidatableConsumerOffer consumerOffer, ParticipantAgent agent) {
        String consumerIdentity = agent.getIdentity();
        if (consumerIdentity == null) {
            return Result.failure((String)"Invalid consumer identity");
        }
        Result<Policy> accessPolicyResult = this.evaluatePolicy(consumerOffer.getAccessPolicy(), "catalog", agent, consumerOffer.getOfferId());
        if (accessPolicyResult.failed()) {
            return accessPolicyResult;
        }
        Asset targetAsset = this.assetIndex.findById(consumerOffer.getOfferId().assetIdPart());
        if (targetAsset == null) {
            return Result.failure((String)("Invalid target: " + consumerOffer.getOfferId().assetIdPart()));
        }
        ArrayList<Criterion> testCriteria = new ArrayList<Criterion>(consumerOffer.getContractDefinition().getAssetsSelector());
        testCriteria.add(new Criterion((Object)"https://w3id.org/edc/v0.0.1/ns/id", "=", (Object)consumerOffer.getOfferId().assetIdPart()));
        if (this.assetIndex.countAssets(testCriteria) <= 0L) {
            return Result.failure((String)"Asset ID from the ContractOffer is not included in the ContractDefinition");
        }
        Policy contractPolicy = consumerOffer.getContractPolicy().withTarget(consumerOffer.getOfferId().assetIdPart());
        return this.evaluatePolicy(contractPolicy, "contract.negotiation", agent, consumerOffer.getOfferId());
    }

    private Result<Policy> evaluatePolicy(Policy policy, String scope, ParticipantAgent agent, ContractOfferId offerId) {
        PolicyContext policyContext = PolicyContextImpl.Builder.newInstance().additional(ParticipantAgent.class, (Object)agent).build();
        Result policyResult = this.policyEngine.evaluate(scope, policy, policyContext);
        if (policyResult.failed()) {
            return Result.failure((String)String.format("Policy in scope %s not fulfilled for offer %s, policy evaluation %s", scope, offerId.toString(), policyResult.getFailureDetail()));
        }
        return Result.success((Object)policy);
    }

    @NotNull
    private Result<ContractOffer> createContractOffer(Policy policy, ContractOfferId contractOfferId) {
        if (!contractOfferId.assetIdPart().equals(policy.getTarget())) {
            return Result.failure((String)"Policy target %s does not match the asset ID in the contract offer %s".formatted(policy.getTarget(), contractOfferId.assetIdPart()));
        }
        return Result.success((Object)ContractOffer.Builder.newInstance().id(contractOfferId.toString()).policy(policy).assetId(contractOfferId.assetIdPart()).build());
    }
}

