/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.policy;

import java.util.Optional;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.policy.spi.store.PolicyArchive;
import org.eclipse.edc.policy.model.Policy;

public class PolicyArchiveImpl
implements PolicyArchive {
    private final ContractNegotiationStore contractNegotiationStore;

    public PolicyArchiveImpl(ContractNegotiationStore contractNegotiationStore) {
        this.contractNegotiationStore = contractNegotiationStore;
    }

    public Policy findPolicyForContract(String contractId) {
        return Optional.ofNullable(contractId).map(arg_0 -> ((ContractNegotiationStore)this.contractNegotiationStore).findContractAgreement(arg_0)).map(this::mapAgreementPolicy).orElse(null);
    }

    private Policy mapAgreementPolicy(ContractAgreement contractAgreement) {
        Policy policy = contractAgreement.getPolicy();
        String assignee = Optional.ofNullable(policy.getAssignee()).orElseGet(() -> ((ContractAgreement)contractAgreement).getConsumerId());
        String assigner = Optional.ofNullable(policy.getAssigner()).orElseGet(() -> ((ContractAgreement)contractAgreement).getProviderId());
        return policy.toBuilder().assignee(assignee).assigner(assigner).build();
    }
}

