/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.offer;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.ContractDefinitionResolver;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.store.ContractDefinitionStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.controlplane.policy.spi.PolicyDefinition;
import org.eclipse.edc.connector.controlplane.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.policy.engine.spi.PolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyContextImpl;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.spi.agent.ParticipantAgent;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractDefinitionResolverImpl
implements ContractDefinitionResolver {
    private final PolicyEngine policyEngine;
    private final PolicyDefinitionStore policyStore;
    private final Monitor monitor;
    private final ContractDefinitionStore definitionStore;

    public ContractDefinitionResolverImpl(Monitor monitor, ContractDefinitionStore contractDefinitionStore, PolicyEngine policyEngine, PolicyDefinitionStore policyStore) {
        this.monitor = monitor;
        this.definitionStore = contractDefinitionStore;
        this.policyEngine = policyEngine;
        this.policyStore = policyStore;
    }

    @NotNull
    public Stream<ContractDefinition> definitionsFor(ParticipantAgent agent) {
        return this.definitionStore.findAll(QuerySpec.max()).filter(definition -> this.evaluateAccessPolicy((ContractDefinition)definition, agent));
    }

    @Nullable
    public ContractDefinition definitionFor(ParticipantAgent agent, String definitionId) {
        return Optional.of(definitionId).map(arg_0 -> ((ContractDefinitionStore)this.definitionStore).findById(arg_0)).filter(definition -> this.evaluateAccessPolicy((ContractDefinition)definition, agent)).orElse(null);
    }

    private boolean evaluateAccessPolicy(ContractDefinition definition, ParticipantAgent agent) {
        PolicyContext policyContext = PolicyContextImpl.Builder.newInstance().additional(ParticipantAgent.class, (Object)agent).build();
        Result accessResult = Optional.of(definition.getAccessPolicyId()).map(arg_0 -> ((PolicyDefinitionStore)this.policyStore).findById(arg_0)).map(PolicyDefinition::getPolicy).map(policy -> this.policyEngine.evaluate("catalog", policy, policyContext)).orElse(Result.failure((String)String.format("Policy %s not found", definition.getAccessPolicyId())));
        if (accessResult.failed()) {
            this.monitor.debug(String.format("Access not granted for %s: \n%s", definition.getId(), String.join((CharSequence)"\n", accessResult.getFailureMessages())), new Throwable[0]);
            return false;
        }
        return true;
    }
}

