/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.offer;

import java.util.List;
import org.eclipse.edc.connector.controlplane.contract.spi.ContractOfferId;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.ConsumerOfferResolver;
import org.eclipse.edc.connector.controlplane.contract.spi.offer.store.ContractDefinitionStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ValidatableConsumerOffer;
import org.eclipse.edc.connector.controlplane.policy.spi.PolicyDefinition;
import org.eclipse.edc.connector.controlplane.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.jetbrains.annotations.NotNull;

public class ConsumerOfferResolverImpl
implements ConsumerOfferResolver {
    private final ContractDefinitionStore contractDefinitionStore;
    private final PolicyDefinitionStore policyDefinitionStore;

    public ConsumerOfferResolverImpl(ContractDefinitionStore contractDefinitionStore, PolicyDefinitionStore policyDefinitionStore) {
        this.contractDefinitionStore = contractDefinitionStore;
        this.policyDefinitionStore = policyDefinitionStore;
    }

    @NotNull
    public ServiceResult<ValidatableConsumerOffer> resolveOffer(String offerId) {
        Result parsedResult = ContractOfferId.parseId((String)offerId);
        if (parsedResult.failed()) {
            return ServiceResult.badRequest((List)parsedResult.getFailureMessages());
        }
        String definitionId = ((ContractOfferId)parsedResult.getContent()).definitionPart();
        ContractDefinition contractDefinition = this.contractDefinitionStore.findById(definitionId);
        if (contractDefinition == null) {
            return ServiceResult.notFound((String)String.format("Contract definition with id %s not found", definitionId));
        }
        PolicyDefinition accessPolicy = this.policyDefinitionStore.findById(contractDefinition.getAccessPolicyId());
        if (accessPolicy == null) {
            return ServiceResult.notFound((String)String.format("Policy with id %s not found", contractDefinition.getAccessPolicyId()));
        }
        PolicyDefinition contractPolicy = this.policyDefinitionStore.findById(contractDefinition.getContractPolicyId());
        if (contractPolicy == null) {
            return ServiceResult.notFound((String)String.format("Policy with id %s not found", contractDefinition.getContractPolicyId()));
        }
        return ServiceResult.success((Object)ValidatableConsumerOffer.Builder.newInstance().contractDefinition(contractDefinition).accessPolicy(accessPolicy.getPolicy()).contractPolicy(contractPolicy.getPolicy()).offerId((ContractOfferId)parsedResult.getContent()).build());
    }
}

