/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.negotiation;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Optional;
import org.eclipse.edc.connector.controlplane.contract.negotiation.AbstractContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ProviderContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.offer.ContractOffer;
import org.eclipse.edc.connector.controlplane.contract.spi.types.protocol.ContractNegotiationAck;
import org.eclipse.edc.policy.model.PolicyType;
import org.eclipse.edc.spi.types.domain.message.ProcessRemoteMessage;
import org.eclipse.edc.statemachine.StateMachineManager;
import org.eclipse.edc.statemachine.retry.AsyncStatusResultRetryProcess;

public class ProviderContractNegotiationManagerImpl
extends AbstractContractNegotiationManager
implements ProviderContractNegotiationManager {
    private ProviderContractNegotiationManagerImpl() {
    }

    protected StateMachineManager.Builder configureStateMachineManager(StateMachineManager.Builder builder) {
        return builder.processor(this.processNegotiationsInState(ContractNegotiationStates.OFFERING, this::processOffering)).processor(this.processNegotiationsInState(ContractNegotiationStates.REQUESTED, this::processRequested)).processor(this.processNegotiationsInState(ContractNegotiationStates.ACCEPTED, this::processAccepted)).processor(this.processNegotiationsInState(ContractNegotiationStates.AGREEING, this::processAgreeing)).processor(this.processNegotiationsInState(ContractNegotiationStates.VERIFIED, this::processVerified)).processor(this.processNegotiationsInState(ContractNegotiationStates.FINALIZING, this::processFinalizing)).processor(this.processNegotiationsInState(ContractNegotiationStates.TERMINATING, this::processTerminating));
    }

    @Override
    protected ContractNegotiation.Type type() {
        return ContractNegotiation.Type.PROVIDER;
    }

    @WithSpan
    private boolean processOffering(ContractNegotiation negotiation) {
        ContractOfferMessage.Builder messageBuilder = ContractOfferMessage.Builder.newInstance().contractOffer(negotiation.getLastContractOffer()).callbackAddress(this.protocolWebhook.url());
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, ContractNegotiationAck.class).onSuccessResult(this::transitionToOffered).onFailure((n, throwable) -> this.transitionToOffering((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n, String.format("Failed to send offer to consumer: %s", throwable.getMessage())))).execute("[Provider] send offer");
    }

    @WithSpan
    private boolean processRequested(ContractNegotiation negotiation) {
        this.transitionToAgreeing(negotiation);
        return true;
    }

    @WithSpan
    private boolean processAccepted(ContractNegotiation negotiation) {
        this.transitionToAgreeing(negotiation);
        return true;
    }

    @WithSpan
    private boolean processAgreeing(ContractNegotiation negotiation) {
        ContractAgreement agreement = Optional.ofNullable(negotiation.getContractAgreement()).orElseGet(() -> {
            ContractOffer lastOffer = negotiation.getLastContractOffer();
            return ContractAgreement.Builder.newInstance().contractSigningDate(this.clock.instant().getEpochSecond()).providerId(this.participantId).consumerId(negotiation.getCounterPartyId()).policy(lastOffer.getPolicy().toBuilder().type(PolicyType.CONTRACT).build()).assetId(lastOffer.getAssetId()).build();
        });
        ContractAgreementMessage.Builder messageBuilder = ContractAgreementMessage.Builder.newInstance().contractAgreement(agreement);
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, Object.class).onSuccess((n, result) -> this.transitionToAgreed((ContractNegotiation)n, agreement)).onFailure((n, throwable) -> this.transitionToAgreeing((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n, String.format("Failed to send agreement to consumer: %s", throwable.getMessage())))).execute("[Provider] send agreement");
    }

    @WithSpan
    private boolean processVerified(ContractNegotiation negotiation) {
        this.transitionToFinalizing(negotiation);
        return true;
    }

    @WithSpan
    private boolean processFinalizing(ContractNegotiation negotiation) {
        ContractNegotiationEventMessage.Builder messageBuilder = ContractNegotiationEventMessage.Builder.newInstance().type(ContractNegotiationEventMessage.Type.FINALIZED).policy(negotiation.getContractAgreement().getPolicy());
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, Object.class).onSuccess((n, result) -> this.transitionToFinalized((ContractNegotiation)n)).onFailure((n, throwable) -> this.transitionToFinalizing((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n, String.format("Failed to send finalization to consumer: %s", throwable.getMessage())))).execute("[Provider] send finalization");
    }

    public static class Builder
    extends AbstractContractNegotiationManager.Builder<ProviderContractNegotiationManagerImpl> {
        private Builder() {
            super(new ProviderContractNegotiationManagerImpl());
        }

        public static Builder newInstance() {
            return new Builder();
        }
    }
}

