/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.negotiation;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.UUID;
import org.eclipse.edc.connector.controlplane.contract.negotiation.AbstractContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ConsumerContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequest;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.protocol.ContractNegotiationAck;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.message.ProcessRemoteMessage;
import org.eclipse.edc.statemachine.StateMachineManager;
import org.eclipse.edc.statemachine.retry.AsyncStatusResultRetryProcess;

public class ConsumerContractNegotiationManagerImpl
extends AbstractContractNegotiationManager
implements ConsumerContractNegotiationManager {
    private ConsumerContractNegotiationManagerImpl() {
    }

    protected StateMachineManager.Builder configureStateMachineManager(StateMachineManager.Builder builder) {
        return builder.processor(this.processNegotiationsInState(ContractNegotiationStates.INITIAL, this::processInitial)).processor(this.processNegotiationsInState(ContractNegotiationStates.REQUESTING, this::processRequesting)).processor(this.processNegotiationsInState(ContractNegotiationStates.ACCEPTING, this::processAccepting)).processor(this.processNegotiationsInState(ContractNegotiationStates.AGREED, this::processAgreed)).processor(this.processNegotiationsInState(ContractNegotiationStates.VERIFYING, this::processVerifying)).processor(this.processNegotiationsInState(ContractNegotiationStates.TERMINATING, this::processTerminating));
    }

    @WithSpan
    public StatusResult<ContractNegotiation> initiate(ContractRequest request) {
        String id = UUID.randomUUID().toString();
        ContractNegotiation negotiation = ((ContractNegotiation.Builder)((ContractNegotiation.Builder)ContractNegotiation.Builder.newInstance().id(id)).protocol(request.getProtocol()).counterPartyId(request.getProviderId()).counterPartyAddress(request.getCounterPartyAddress()).callbackAddresses(request.getCallbackAddresses()).traceContext(this.telemetry.getCurrentTraceContext())).type(ContractNegotiation.Type.CONSUMER).build();
        negotiation.addContractOffer(request.getContractOffer());
        this.transitionToInitial(negotiation);
        return StatusResult.success((Object)negotiation);
    }

    @Override
    ContractNegotiation.Type type() {
        return ContractNegotiation.Type.CONSUMER;
    }

    @WithSpan
    private boolean processInitial(ContractNegotiation negotiation) {
        this.transitionToRequesting(negotiation);
        return true;
    }

    @WithSpan
    private boolean processRequesting(ContractNegotiation negotiation) {
        ContractRequestMessage.Builder messageBuilder = ContractRequestMessage.Builder.newInstance().contractOffer(negotiation.getLastContractOffer()).callbackAddress(this.protocolWebhook.url()).type(ContractRequestMessage.Type.INITIAL);
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, ContractNegotiationAck.class).onSuccessResult(this::transitionToRequested).onFailure((n, throwable) -> this.transitionToRequesting((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n, String.format("Failed to send request to provider: %s", throwable.getMessage())))).execute("[Consumer] send request");
    }

    @WithSpan
    private boolean processAccepting(ContractNegotiation negotiation) {
        ContractNegotiationEventMessage.Builder messageBuilder = ContractNegotiationEventMessage.Builder.newInstance().type(ContractNegotiationEventMessage.Type.ACCEPTED);
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, Object.class).onSuccess((n, result) -> this.transitionToAccepted((ContractNegotiation)n)).onFailure((n, throwable) -> this.transitionToAccepting((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n, String.format("Failed to send acceptance to provider: %s", throwable.getMessage())))).execute("[consumer] send acceptance");
    }

    @WithSpan
    private boolean processAgreed(ContractNegotiation negotiation) {
        this.transitionToVerifying(negotiation);
        return true;
    }

    @WithSpan
    private boolean processVerifying(ContractNegotiation negotiation) {
        ContractAgreementVerificationMessage.Builder messageBuilder = ContractAgreementVerificationMessage.Builder.newInstance().policy(negotiation.getContractAgreement().getPolicy());
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, Object.class).onSuccess((n, result) -> this.transitionToVerified((ContractNegotiation)n)).onFailure((n, throwable) -> this.transitionToVerifying((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n, String.format("Failed to send verification to provider: %s", throwable.getMessage())))).execute("[consumer] send verification");
    }

    public static class Builder
    extends AbstractContractNegotiationManager.Builder<ConsumerContractNegotiationManagerImpl> {
        private Builder() {
            super(new ConsumerContractNegotiationManagerImpl());
        }

        public static Builder newInstance() {
            return new Builder();
        }
    }
}

