/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.negotiation;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ContractNegotiationPendingGuard;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.observe.ContractNegotiationObservable;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationStates;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.protocol.ContractNegotiationAck;
import org.eclipse.edc.connector.controlplane.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.persistence.StateEntityStore;
import org.eclipse.edc.spi.protocol.ProtocolWebhook;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.types.domain.message.ProcessRemoteMessage;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.statemachine.AbstractStateEntityManager;
import org.eclipse.edc.statemachine.Processor;
import org.eclipse.edc.statemachine.ProcessorImpl;
import org.eclipse.edc.statemachine.retry.AsyncStatusResultRetryProcess;

public abstract class AbstractContractNegotiationManager
extends AbstractStateEntityManager<ContractNegotiation, ContractNegotiationStore> {
    protected String participantId;
    protected RemoteMessageDispatcherRegistry dispatcherRegistry;
    protected ContractNegotiationObservable observable;
    protected PolicyDefinitionStore policyStore;
    protected ProtocolWebhook protocolWebhook;
    protected ContractNegotiationPendingGuard pendingGuard = it -> false;

    abstract ContractNegotiation.Type type();

    protected Processor processNegotiationsInState(ContractNegotiationStates state, Function<ContractNegotiation, Boolean> function) {
        Criterion[] filter = new Criterion[]{StateEntityStore.hasState((int)state.code()), StateEntityStore.isNotPending(), new Criterion((Object)"type", "=", (Object)this.type().name())};
        return ProcessorImpl.Builder.newInstance(() -> ((ContractNegotiationStore)this.store).nextNotLeased(this.batchSize, filter)).process(this.telemetry.contextPropagationMiddleware(function)).guard((Predicate)this.pendingGuard, this::setPending).onNotProcessed(x$0 -> this.breakLease((StatefulEntity)x$0)).build();
    }

    private boolean setPending(ContractNegotiation contractNegotiation) {
        contractNegotiation.setPending(true);
        this.update((StatefulEntity)contractNegotiation);
        return true;
    }

    @WithSpan
    protected boolean processTerminating(ContractNegotiation negotiation) {
        ContractNegotiationTerminationMessage.Builder messageBuilder = ContractNegotiationTerminationMessage.Builder.newInstance().rejectionReason(negotiation.getErrorDetail()).policy(negotiation.getLastContractOffer().getPolicy());
        return ((AsyncStatusResultRetryProcess)((AsyncStatusResultRetryProcess)this.dispatch((ProcessRemoteMessage.Builder<?, ?>)messageBuilder, negotiation, (Class)Object.class).onSuccess((n, result) -> this.transitionToTerminated((ContractNegotiation)n)).onFailure((n, throwable) -> this.transitionToTerminating((ContractNegotiation)n))).onFatalError((n, failure) -> this.transitionToTerminated((ContractNegotiation)n, failure.getFailureDetail())).onRetryExhausted((n, throwable) -> this.transitionToTerminated((ContractNegotiation)n, String.format("Failed to send termination to counter party: %s", throwable.getMessage())))).execute("[%s] send termination".formatted(this.type().name()));
    }

    protected <T> AsyncStatusResultRetryProcess<ContractNegotiation, T, ?> dispatch(ProcessRemoteMessage.Builder<?, ?> messageBuilder, ContractNegotiation negotiation, Class<T> responseType) {
        messageBuilder.counterPartyAddress(negotiation.getCounterPartyAddress()).counterPartyId(negotiation.getCounterPartyId()).protocol(negotiation.getProtocol()).processId(Optional.ofNullable(negotiation.getCorrelationId()).orElse(negotiation.getId()));
        if (this.type() == ContractNegotiation.Type.CONSUMER) {
            messageBuilder.consumerPid(negotiation.getId()).providerPid(negotiation.getCorrelationId());
        } else {
            messageBuilder.providerPid(negotiation.getId()).consumerPid(negotiation.getCorrelationId());
        }
        if (negotiation.lastSentProtocolMessage() != null) {
            messageBuilder.id(negotiation.lastSentProtocolMessage());
        }
        ProcessRemoteMessage message = messageBuilder.build();
        negotiation.lastSentProtocolMessage(message.getId());
        return this.entityRetryProcessFactory.doAsyncStatusResultProcess((StatefulEntity)negotiation, () -> this.dispatcherRegistry.dispatch(responseType, (RemoteMessage)message));
    }

    protected void transitionToInitial(ContractNegotiation negotiation) {
        negotiation.transitionInitial();
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.initiated(negotiation));
    }

    protected void transitionToRequesting(ContractNegotiation negotiation) {
        negotiation.transitionRequesting();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToRequested(ContractNegotiation negotiation, ContractNegotiationAck ack) {
        negotiation.transitionRequested();
        negotiation.setCorrelationId(ack.getProviderPid());
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.requested(negotiation));
    }

    protected void transitionToAccepting(ContractNegotiation negotiation) {
        negotiation.transitionAccepting();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToAccepted(ContractNegotiation negotiation) {
        negotiation.transitionAccepted();
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.accepted(negotiation));
    }

    protected void transitionToOffering(ContractNegotiation negotiation) {
        negotiation.transitionOffering();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToOffered(ContractNegotiation negotiation, ContractNegotiationAck ack) {
        negotiation.transitionOffered();
        negotiation.setCorrelationId(ack.getConsumerPid());
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.offered(negotiation));
    }

    protected void transitionToAgreeing(ContractNegotiation negotiation) {
        negotiation.transitionAgreeing();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToAgreed(ContractNegotiation negotiation, ContractAgreement agreement) {
        negotiation.setContractAgreement(agreement);
        negotiation.transitionAgreed();
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.agreed(negotiation));
    }

    protected void transitionToVerifying(ContractNegotiation negotiation) {
        negotiation.transitionVerifying();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToVerified(ContractNegotiation negotiation) {
        negotiation.transitionVerified();
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.verified(negotiation));
    }

    protected void transitionToFinalizing(ContractNegotiation negotiation) {
        negotiation.transitionFinalizing();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToFinalized(ContractNegotiation negotiation) {
        negotiation.transitionFinalized();
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.finalized(negotiation));
    }

    protected void transitionToTerminating(ContractNegotiation negotiation, String message) {
        negotiation.transitionTerminating(message);
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToTerminating(ContractNegotiation negotiation) {
        negotiation.transitionTerminating();
        this.update((StatefulEntity)negotiation);
    }

    protected void transitionToTerminated(ContractNegotiation negotiation, String message) {
        negotiation.setErrorDetail(message);
        this.transitionToTerminated(negotiation);
    }

    protected void transitionToTerminated(ContractNegotiation negotiation) {
        negotiation.transitionTerminated();
        this.update((StatefulEntity)negotiation);
        this.observable.invokeForEach(l -> l.terminated(negotiation));
    }

    public static class Builder<T extends AbstractContractNegotiationManager>
    extends AbstractStateEntityManager.Builder<ContractNegotiation, ContractNegotiationStore, T, Builder<T>> {
        protected Builder(T manager) {
            super(manager);
        }

        public Builder<T> self() {
            return this;
        }

        public Builder<T> participantId(String id) {
            ((AbstractContractNegotiationManager)this.manager).participantId = id;
            return this;
        }

        public Builder<T> dispatcherRegistry(RemoteMessageDispatcherRegistry dispatcherRegistry) {
            ((AbstractContractNegotiationManager)this.manager).dispatcherRegistry = dispatcherRegistry;
            return this;
        }

        public Builder<T> observable(ContractNegotiationObservable observable) {
            ((AbstractContractNegotiationManager)this.manager).observable = observable;
            return this;
        }

        public Builder<T> policyStore(PolicyDefinitionStore policyStore) {
            ((AbstractContractNegotiationManager)this.manager).policyStore = policyStore;
            return this;
        }

        public Builder<T> protocolWebhook(ProtocolWebhook protocolWebhook) {
            ((AbstractContractNegotiationManager)this.manager).protocolWebhook = protocolWebhook;
            return this;
        }

        public Builder<T> pendingGuard(ContractNegotiationPendingGuard pendingGuard) {
            ((AbstractContractNegotiationManager)this.manager).pendingGuard = pendingGuard;
            return this;
        }

        public T build() {
            super.build();
            Objects.requireNonNull(((AbstractContractNegotiationManager)this.manager).participantId, "participantId");
            Objects.requireNonNull(((AbstractContractNegotiationManager)this.manager).dispatcherRegistry, "dispatcherRegistry");
            Objects.requireNonNull(((AbstractContractNegotiationManager)this.manager).observable, "observable");
            Objects.requireNonNull(((AbstractContractNegotiationManager)this.manager).policyStore, "policyStore");
            return (T)((Object)((AbstractContractNegotiationManager)this.manager));
        }
    }
}

