/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract.listener;

import java.time.Clock;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationAccepted;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationAgreed;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationEvent;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationFinalized;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationInitiated;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationOffered;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationRequested;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationTerminated;
import org.eclipse.edc.connector.controlplane.contract.spi.event.contractnegotiation.ContractNegotiationVerified;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.observe.ContractNegotiationListener;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.spi.event.Event;
import org.eclipse.edc.spi.event.EventEnvelope;
import org.eclipse.edc.spi.event.EventRouter;

public class ContractNegotiationEventListener
implements ContractNegotiationListener {
    private final EventRouter eventRouter;
    private final Clock clock;

    public ContractNegotiationEventListener(EventRouter eventRouter, Clock clock) {
        this.eventRouter = eventRouter;
        this.clock = clock;
    }

    public void initiated(ContractNegotiation negotiation) {
        ContractNegotiationInitiated event = (ContractNegotiationInitiated)this.baseBuilder(ContractNegotiationInitiated.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void requested(ContractNegotiation negotiation) {
        ContractNegotiationRequested event = (ContractNegotiationRequested)this.baseBuilder(ContractNegotiationRequested.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void offered(ContractNegotiation negotiation) {
        ContractNegotiationOffered event = (ContractNegotiationOffered)this.baseBuilder(ContractNegotiationOffered.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void accepted(ContractNegotiation negotiation) {
        ContractNegotiationAccepted event = (ContractNegotiationAccepted)this.baseBuilder(ContractNegotiationAccepted.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void terminated(ContractNegotiation negotiation) {
        ContractNegotiationTerminated event = (ContractNegotiationTerminated)this.baseBuilder(ContractNegotiationTerminated.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void agreed(ContractNegotiation negotiation) {
        ContractNegotiationAgreed event = (ContractNegotiationAgreed)this.baseBuilder(ContractNegotiationAgreed.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void verified(ContractNegotiation negotiation) {
        ContractNegotiationVerified event = (ContractNegotiationVerified)this.baseBuilder(ContractNegotiationVerified.Builder.newInstance(), negotiation).build();
        this.publish((ContractNegotiationEvent)event);
    }

    public void finalized(ContractNegotiation negotiation) {
        ContractNegotiationFinalized event = this.baseBuilder(ContractNegotiationFinalized.Builder.newInstance(), negotiation).contractAgreement(negotiation.getContractAgreement()).build();
        this.publish((ContractNegotiationEvent)event);
    }

    private <T extends ContractNegotiationEvent, B extends ContractNegotiationEvent.Builder<T, B>> B baseBuilder(B builder, ContractNegotiation negotiation) {
        return (B)builder.contractNegotiationId(negotiation.getId()).counterPartyAddress(negotiation.getCounterPartyAddress()).callbackAddresses(negotiation.getCallbackAddresses()).contractOffers(negotiation.getContractOffers()).counterPartyId(negotiation.getCounterPartyId()).protocol(negotiation.getProtocol());
    }

    private void publish(ContractNegotiationEvent event) {
        EventEnvelope envelope = EventEnvelope.Builder.newInstance().payload((Event)event).at(this.clock.millis()).build();
        this.eventRouter.publish(envelope);
    }
}

