/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.contract;

import java.time.Clock;
import org.eclipse.edc.connector.controlplane.asset.spi.index.AssetIndex;
import org.eclipse.edc.connector.controlplane.contract.listener.ContractNegotiationEventListener;
import org.eclipse.edc.connector.controlplane.contract.negotiation.AbstractContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.negotiation.ConsumerContractNegotiationManagerImpl;
import org.eclipse.edc.connector.controlplane.contract.negotiation.ProviderContractNegotiationManagerImpl;
import org.eclipse.edc.connector.controlplane.contract.policy.PolicyEquality;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ConsumerContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ContractNegotiationPendingGuard;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.NegotiationWaitStrategy;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.ProviderContractNegotiationManager;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.observe.ContractNegotiationObservable;
import org.eclipse.edc.connector.controlplane.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.controlplane.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.controlplane.contract.validation.ContractValidationServiceImpl;
import org.eclipse.edc.connector.controlplane.policy.contract.ContractExpiryCheckFunction;
import org.eclipse.edc.connector.controlplane.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.policy.engine.spi.AtomicConstraintFunction;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.engine.spi.RuleBindingRegistry;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.runtime.metamodel.annotation.CoreExtension;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.persistence.StateEntityStore;
import org.eclipse.edc.spi.protocol.ProtocolWebhook;
import org.eclipse.edc.spi.retry.ExponentialWaitStrategy;
import org.eclipse.edc.spi.retry.WaitStrategy;
import org.eclipse.edc.spi.system.ExecutorInstrumentation;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.statemachine.retry.EntityRetryProcessConfiguration;
import org.jetbrains.annotations.NotNull;

@Provides(value={ContractValidationService.class, ConsumerContractNegotiationManager.class, ProviderContractNegotiationManager.class})
@CoreExtension
@Extension(value="Contract Core")
public class ContractCoreExtension
implements ServiceExtension {
    public static final String NAME = "Contract Core";
    @Setting(value="the iteration wait time in milliseconds in the negotiation state machine. Default value 1000", type="long")
    private static final String NEGOTIATION_STATE_MACHINE_ITERATION_WAIT_MILLIS = "edc.negotiation.state-machine.iteration-wait-millis";
    @Setting(value="the batch size in the consumer negotiation state machine. Default value 20", type="int")
    private static final String NEGOTIATION_CONSUMER_STATE_MACHINE_BATCH_SIZE = "edc.negotiation.consumer.state-machine.batch-size";
    @Setting(value="the batch size in the provider negotiation state machine. Default value 20", type="int")
    private static final String NEGOTIATION_PROVIDER_STATE_MACHINE_BATCH_SIZE = "edc.negotiation.provider.state-machine.batch-size";
    @Setting(value="how many times a specific operation must be tried before terminating the consumer negotiation with error", type="int", defaultValue="7")
    private static final String NEGOTIATION_CONSUMER_SEND_RETRY_LIMIT = "edc.negotiation.consumer.send.retry.limit";
    @Setting(value="how many times a specific operation must be tried before terminating the provider negotiation with error", type="int", defaultValue="7")
    private static final String NEGOTIATION_PROVIDER_SEND_RETRY_LIMIT = "edc.negotiation.provider.send.retry.limit";
    @Setting(value="The base delay for the consumer negotiation retry mechanism in millisecond", type="long", defaultValue="1000")
    private static final String NEGOTIATION_CONSUMER_SEND_RETRY_BASE_DELAY_MS = "edc.negotiation.consumer.send.retry.base-delay.ms";
    @Setting(value="The base delay for the provider negotiation retry mechanism in millisecond", type="long", defaultValue="1000")
    private static final String NEGOTIATION_PROVIDER_SEND_RETRY_BASE_DELAY_MS = "edc.negotiation.provider.send.retry.base-delay.ms";
    private ConsumerContractNegotiationManagerImpl consumerNegotiationManager;
    private ProviderContractNegotiationManagerImpl providerNegotiationManager;
    @Inject
    private AssetIndex assetIndex;
    @Inject
    private RemoteMessageDispatcherRegistry dispatcherRegistry;
    @Inject
    private ContractNegotiationStore store;
    @Inject
    private PolicyEngine policyEngine;
    @Inject
    private PolicyDefinitionStore policyStore;
    @Inject
    private Monitor monitor;
    @Inject
    private Telemetry telemetry;
    @Inject
    private Clock clock;
    @Inject
    private EventRouter eventRouter;
    @Inject
    private TypeManager typeManager;
    @Inject
    private RuleBindingRegistry ruleBindingRegistry;
    @Inject
    private ProtocolWebhook protocolWebhook;
    @Inject
    private ContractNegotiationObservable observable;
    @Inject
    private ContractNegotiationPendingGuard pendingGuard;
    @Inject
    private ExecutorInstrumentation executorInstrumentation;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.typeManager.registerTypes(new Class[]{ContractNegotiation.class});
        this.registerServices(context);
    }

    public void start() {
        this.consumerNegotiationManager.start();
        this.providerNegotiationManager.start();
    }

    public void shutdown() {
        if (this.consumerNegotiationManager != null) {
            this.consumerNegotiationManager.stop();
        }
        if (this.providerNegotiationManager != null) {
            this.providerNegotiationManager.stop();
        }
    }

    private void registerServices(ServiceExtensionContext context) {
        String participantId = context.getParticipantId();
        PolicyEquality policyEquality = new PolicyEquality(this.typeManager);
        ContractValidationServiceImpl validationService = new ContractValidationServiceImpl(this.assetIndex, this.policyEngine, policyEquality);
        context.registerService(ContractValidationService.class, (Object)validationService);
        this.ruleBindingRegistry.bind("http://www.w3.org/ns/odrl/2/use", "transfer.process");
        this.ruleBindingRegistry.bind("https://w3id.org/edc/v0.0.1/ns/inForceDate", "transfer.process");
        ContractExpiryCheckFunction function = new ContractExpiryCheckFunction();
        this.policyEngine.registerFunction("transfer.process", Permission.class, "https://w3id.org/edc/v0.0.1/ns/inForceDate", (AtomicConstraintFunction)function);
        long iterationWaitMillis = context.getSetting(NEGOTIATION_STATE_MACHINE_ITERATION_WAIT_MILLIS, 1000L);
        ExponentialWaitStrategy waitStrategy = context.hasService(NegotiationWaitStrategy.class) ? (WaitStrategy)context.getService(NegotiationWaitStrategy.class) : new ExponentialWaitStrategy(iterationWaitMillis);
        this.observable.registerListener((Object)new ContractNegotiationEventListener(this.eventRouter, this.clock));
        this.consumerNegotiationManager = (ConsumerContractNegotiationManagerImpl)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)ConsumerContractNegotiationManagerImpl.Builder.newInstance().participantId(participantId).waitStrategy((WaitStrategy)waitStrategy)).dispatcherRegistry(this.dispatcherRegistry).monitor(this.monitor)).observable(this.observable).clock(this.clock)).telemetry(this.telemetry)).executorInstrumentation(this.executorInstrumentation)).store((StateEntityStore)this.store)).policyStore(this.policyStore).batchSize(context.getSetting(NEGOTIATION_CONSUMER_STATE_MACHINE_BATCH_SIZE, 20))).entityRetryProcessConfiguration(this.consumerEntityRetryProcessConfiguration(context))).protocolWebhook(this.protocolWebhook).pendingGuard(this.pendingGuard).build();
        this.providerNegotiationManager = (ProviderContractNegotiationManagerImpl)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)((AbstractContractNegotiationManager.Builder)ProviderContractNegotiationManagerImpl.Builder.newInstance().participantId(participantId).waitStrategy((WaitStrategy)waitStrategy)).dispatcherRegistry(this.dispatcherRegistry).monitor(this.monitor)).observable(this.observable).clock(this.clock)).telemetry(this.telemetry)).executorInstrumentation(this.executorInstrumentation)).store((StateEntityStore)this.store)).policyStore(this.policyStore).batchSize(context.getSetting(NEGOTIATION_PROVIDER_STATE_MACHINE_BATCH_SIZE, 20))).entityRetryProcessConfiguration(this.providerEntityRetryProcessConfiguration(context))).protocolWebhook(this.protocolWebhook).pendingGuard(this.pendingGuard).build();
        context.registerService(ConsumerContractNegotiationManager.class, (Object)this.consumerNegotiationManager);
        context.registerService(ProviderContractNegotiationManager.class, (Object)this.providerNegotiationManager);
    }

    private EntityRetryProcessConfiguration providerEntityRetryProcessConfiguration(ServiceExtensionContext context) {
        int retryLimit = context.getSetting(NEGOTIATION_PROVIDER_SEND_RETRY_LIMIT, 7);
        long retryBaseDelay = context.getSetting(NEGOTIATION_PROVIDER_SEND_RETRY_BASE_DELAY_MS, 1000L);
        return new EntityRetryProcessConfiguration(retryLimit, () -> new ExponentialWaitStrategy(retryBaseDelay));
    }

    @NotNull
    private EntityRetryProcessConfiguration consumerEntityRetryProcessConfiguration(ServiceExtensionContext context) {
        int retryLimit = context.getSetting(NEGOTIATION_CONSUMER_SEND_RETRY_LIMIT, 7);
        long retryBaseDelay = context.getSetting(NEGOTIATION_CONSUMER_SEND_RETRY_BASE_DELAY_MS, 1000L);
        return new EntityRetryProcessConfiguration(retryLimit, () -> new ExponentialWaitStrategy(retryBaseDelay));
    }
}

