/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.transferprocess;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.eclipse.edc.connector.controlplane.api.transferprocess.TransferProcessControlApi;
import org.eclipse.edc.connector.controlplane.api.transferprocess.model.TransferProcessFailStateDto;
import org.eclipse.edc.connector.controlplane.services.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.command.TerminateTransferCommand;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;
import org.eclipse.edc.web.spi.exception.ValidationFailureException;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/transferprocess")
public class TransferProcessControlApiController
implements TransferProcessControlApi {
    public static final String PATH = "/transferprocess";
    private final TransferProcessService transferProcessService;
    private final Validator<TransferProcessFailStateDto> validator = new TransferProcessFailStateDtoValidator();

    public TransferProcessControlApiController(TransferProcessService transferProcessService) {
        this.transferProcessService = transferProcessService;
    }

    @Override
    @POST
    @Path(value="/{processId}/complete")
    public void complete(@PathParam(value="processId") String processId) {
        this.transferProcessService.complete(processId).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, (String)processId));
    }

    @Override
    @POST
    @Path(value="/{processId}/fail")
    public void fail(@PathParam(value="processId") String processId, TransferProcessFailStateDto request) {
        this.validator.validate((Object)request).orElseThrow(ValidationFailureException::new);
        this.transferProcessService.terminate(new TerminateTransferCommand(processId, request.getErrorMessage())).orElseThrow(ServiceResultHandler.exceptionMapper(TransferProcess.class, (String)processId));
    }

    private static class TransferProcessFailStateDtoValidator
    implements Validator<TransferProcessFailStateDto> {
        private TransferProcessFailStateDtoValidator() {
        }

        public ValidationResult validate(TransferProcessFailStateDto input) {
            if (input == null) {
                return ValidationResult.failure((Violation)Violation.violation((String)"requestBody cannot be null", (String)""));
            }
            if (input.getErrorMessage() == null) {
                return ValidationResult.failure((Violation)Violation.violation((String)"errorMessage cannot be null", (String)"errorMessage"));
            }
            return ValidationResult.success();
        }
    }
}

