/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.client.transferprocess;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.edc.connector.api.client.spi.transferprocess.TransferProcessApiClient;
import org.eclipse.edc.connector.api.client.transferprocess.model.TransferProcessFailRequest;
import org.eclipse.edc.spi.http.EdcHttpClient;
import org.eclipse.edc.spi.http.FallbackFactories;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class TransferProcessHttpClient
implements TransferProcessApiClient {
    public static final MediaType TYPE_JSON = MediaType.parse((String)"application/json");
    private final EdcHttpClient httpClient;
    private final ObjectMapper mapper;
    private final Monitor monitor;

    public TransferProcessHttpClient(EdcHttpClient httpClient, ObjectMapper mapper, Monitor monitor) {
        this.httpClient = httpClient;
        this.mapper = mapper;
        this.monitor = monitor;
    }

    public Result<Void> completed(DataFlowRequest dataFlowRequest) {
        return this.sendRequest(dataFlowRequest, "complete", null);
    }

    public Result<Void> failed(DataFlowRequest dataFlowRequest, String reason) {
        return this.sendRequest(dataFlowRequest, "fail", TransferProcessFailRequest.Builder.newInstance().errorMessage(reason).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result<Void> sendRequest(DataFlowRequest dataFlowRequest, String action, Object body) {
        if (dataFlowRequest.getCallbackAddress() == null) {
            this.monitor.warning(String.format("Missing callback address in DataFlowRequest %s", dataFlowRequest.getId()), new Throwable[0]);
            return Result.success();
        }
        try {
            Request request = this.createRequest(this.buildUrl(dataFlowRequest, action), body);
            try (Response response = this.httpClient.execute(request, List.of(FallbackFactories.retryWhenStatusIsNotIn((int[])new int[]{200, 204})));){
                if (response.isSuccessful()) return Result.success();
                String message = "Failed to send callback request: received %s from the TransferProcess API".formatted(response.code());
                this.monitor.severe(message, new Throwable[0]);
                Result result = Result.failure((String)message);
                return result;
            }
        }
        catch (Exception e) {
            this.monitor.severe("Failed to send callback request", new Throwable[]{e});
            return Result.failure((String)("Failed to send callback request: " + e.getMessage()));
        }
    }

    @NotNull
    private String buildUrl(DataFlowRequest dataFlowRequest, String action) {
        URI callbackAddress = dataFlowRequest.getCallbackAddress();
        URI url = URI.create(callbackAddress + "/").resolve(String.format("./transferprocess/%s/%s", dataFlowRequest.getProcessId(), action)).normalize();
        return url.toString();
    }

    private Request createRequest(String url, Object body) throws JsonProcessingException {
        RequestBody requestBody = body != null ? RequestBody.create((String)this.mapper.writeValueAsString(body), (MediaType)TYPE_JSON) : RequestBody.create((String)"", null);
        return new Request.Builder().url(url).post(requestBody).build();
    }
}

