/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.api.client.transferprocess;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.edc.connector.controlplane.api.client.spi.transferprocess.TransferProcessApiClient;
import org.eclipse.edc.connector.controlplane.api.client.transferprocess.model.TransferProcessFailRequest;
import org.eclipse.edc.http.spi.ControlApiHttpClient;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.jetbrains.annotations.NotNull;

public class TransferProcessHttpClient
implements TransferProcessApiClient {
    public static final MediaType TYPE_JSON = MediaType.parse((String)"application/json");
    private final ControlApiHttpClient httpClient;
    private final ObjectMapper mapper;
    private final Monitor monitor;

    public TransferProcessHttpClient(ControlApiHttpClient httpClient, ObjectMapper mapper, Monitor monitor) {
        this.httpClient = httpClient;
        this.mapper = mapper;
        this.monitor = monitor;
    }

    public Result<Void> completed(DataFlowStartMessage dataFlowStartMessage) {
        return this.sendRequest(dataFlowStartMessage, "complete", null);
    }

    public Result<Void> failed(DataFlowStartMessage dataFlowStartMessage, String reason) {
        return this.sendRequest(dataFlowStartMessage, "fail", TransferProcessFailRequest.Builder.newInstance().errorMessage(reason).build());
    }

    private Result<Void> sendRequest(DataFlowStartMessage dataFlowStartMessage, String action, Object body) {
        block4: {
            if (dataFlowStartMessage.getCallbackAddress() != null) {
                try {
                    Request.Builder builder = new Request.Builder().url(this.buildUrl(dataFlowStartMessage, action)).post(this.createRequestBody(body));
                    ServiceResult result = this.httpClient.execute(builder);
                    if (result.failed()) {
                        String message = "Failed to send callback request: %s".formatted(result.getFailureDetail());
                        this.monitor.severe(message, new Throwable[0]);
                        return Result.failure((String)message);
                    }
                    break block4;
                }
                catch (Exception e) {
                    this.monitor.severe("Failed to send callback request", new Throwable[]{e});
                    return Result.failure((String)("Failed to send callback request: " + e.getMessage()));
                }
            }
            this.monitor.warning(String.format("Missing callback address in DataFlowRequest %s", dataFlowStartMessage.getId()), new Throwable[0]);
        }
        return Result.success();
    }

    @NotNull
    private String buildUrl(DataFlowStartMessage dataFlowStartMessage, String action) {
        URI callbackAddress = dataFlowStartMessage.getCallbackAddress();
        URI url = URI.create(String.valueOf(callbackAddress) + "/").resolve(String.format("./transferprocess/%s/%s", dataFlowStartMessage.getProcessId(), action)).normalize();
        return url.toString();
    }

    @NotNull
    private RequestBody createRequestBody(Object body) throws JsonProcessingException {
        if (body != null) {
            return RequestBody.create((String)this.mapper.writeValueAsString(body), (MediaType)TYPE_JSON);
        }
        return RequestBody.create((String)"", null);
    }
}

