/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.transferprocess;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.edc.connector.service.query.QueryValidator;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessService;
import org.eclipse.edc.connector.transfer.spi.TransferProcessManager;
import org.eclipse.edc.connector.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.connector.transfer.spi.types.DeprovisionedResource;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionResponse;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionedContentResource;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionedDataAddressResource;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionedDataDestinationResource;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionedResource;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcessStates;
import org.eclipse.edc.connector.transfer.spi.types.TransferRequest;
import org.eclipse.edc.connector.transfer.spi.types.command.AddProvisionedResourceCommand;
import org.eclipse.edc.connector.transfer.spi.types.command.CompleteTransferCommand;
import org.eclipse.edc.connector.transfer.spi.types.command.DeprovisionCompleteCommand;
import org.eclipse.edc.connector.transfer.spi.types.command.DeprovisionRequest;
import org.eclipse.edc.connector.transfer.spi.types.command.TerminateTransferCommand;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.command.EntityCommand;
import org.eclipse.edc.spi.dataaddress.DataAddressValidator;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferProcessServiceImpl
implements TransferProcessService {
    private final TransferProcessStore transferProcessStore;
    private final TransferProcessManager manager;
    private final TransactionContext transactionContext;
    private final QueryValidator queryValidator;
    private final DataAddressValidator dataAddressValidator;
    private final CommandHandlerRegistry commandHandlerRegistry;

    public TransferProcessServiceImpl(TransferProcessStore transferProcessStore, TransferProcessManager manager, TransactionContext transactionContext, DataAddressValidator dataAddressValidator, CommandHandlerRegistry commandHandlerRegistry) {
        this.transferProcessStore = transferProcessStore;
        this.manager = manager;
        this.transactionContext = transactionContext;
        this.dataAddressValidator = dataAddressValidator;
        this.commandHandlerRegistry = commandHandlerRegistry;
        this.queryValidator = new QueryValidator(TransferProcess.class, this.getSubtypes());
    }

    @Nullable
    public TransferProcess findById(String transferProcessId) {
        return (TransferProcess)this.transactionContext.execute(() -> (TransferProcess)this.transferProcessStore.findById(transferProcessId));
    }

    public ServiceResult<Stream<TransferProcess>> query(QuerySpec query) {
        Result<Void> result = this.queryValidator.validate(query);
        if (result.failed()) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", result.getFailureDetail())});
        }
        return ServiceResult.success((Object)((Stream)this.transactionContext.execute(() -> this.transferProcessStore.findAll(query))));
    }

    @Nullable
    public String getState(String transferProcessId) {
        return (String)this.transactionContext.execute(() -> {
            TransferProcess process = (TransferProcess)this.transferProcessStore.findById(transferProcessId);
            return Optional.ofNullable(process).map(p -> TransferProcessStates.from((int)p.getState()).name()).orElse(null);
        });
    }

    @NotNull
    public ServiceResult<Void> complete(String transferProcessId) {
        CompleteTransferCommand command = new CompleteTransferCommand(transferProcessId);
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute((EntityCommand)command).flatMap(ServiceResult::from));
    }

    @NotNull
    public ServiceResult<Void> terminate(TerminateTransferCommand command) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute((EntityCommand)command).flatMap(ServiceResult::from));
    }

    @NotNull
    public ServiceResult<Void> deprovision(String transferProcessId) {
        DeprovisionRequest command = new DeprovisionRequest(transferProcessId);
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute((EntityCommand)command).flatMap(ServiceResult::from));
    }

    @NotNull
    public ServiceResult<TransferProcess> initiateTransfer(TransferRequest request) {
        Result validDestination = this.dataAddressValidator.validate(request.getDataDestination());
        if (validDestination.failed()) {
            return ServiceResult.badRequest((String[])validDestination.getFailureMessages().toArray(new String[0]));
        }
        return (ServiceResult)this.transactionContext.execute(() -> {
            StatusResult transferInitiateResult = this.manager.initiateConsumerRequest(request);
            return Optional.ofNullable(transferInitiateResult).filter(AbstractResult::succeeded).map(AbstractResult::getContent).map(ServiceResult::success).orElse(ServiceResult.conflict((String)"Request couldn't be initialised."));
        });
    }

    public ServiceResult<Void> completeDeprovision(String transferProcessId, DeprovisionedResource resource) {
        DeprovisionCompleteCommand command = new DeprovisionCompleteCommand(transferProcessId, resource);
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute((EntityCommand)command).flatMap(ServiceResult::from));
    }

    public ServiceResult<Void> addProvisionedResource(String transferProcessId, ProvisionResponse response) {
        AddProvisionedResourceCommand command = new AddProvisionedResourceCommand(transferProcessId, response);
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)this.commandHandlerRegistry.execute((EntityCommand)command).flatMap(ServiceResult::from));
    }

    private Map<Class<?>, List<Class<?>>> getSubtypes() {
        return Map.of(ProvisionedResource.class, List.of(ProvisionedDataAddressResource.class), ProvisionedDataAddressResource.class, List.of(ProvisionedDataDestinationResource.class, ProvisionedContentResource.class));
    }
}

