/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.transferprocess;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.spi.transferprocess.TransferProcessProtocolService;
import org.eclipse.edc.connector.transfer.spi.observe.TransferProcessObservable;
import org.eclipse.edc.connector.transfer.spi.observe.TransferProcessStartedData;
import org.eclipse.edc.connector.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcessStates;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferCompletionMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferRemoteMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferRequestMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferStartMessage;
import org.eclipse.edc.connector.transfer.spi.types.protocol.TransferTerminationMessage;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.dataaddress.DataAddressValidator;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.AbstractResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class TransferProcessProtocolServiceImpl
implements TransferProcessProtocolService {
    private final TransferProcessStore transferProcessStore;
    private final TransactionContext transactionContext;
    private final ContractNegotiationStore negotiationStore;
    private final ContractValidationService contractValidationService;
    private final DataAddressValidator dataAddressValidator;
    private final TransferProcessObservable observable;
    private final Clock clock;
    private final Monitor monitor;
    private final Telemetry telemetry;

    public TransferProcessProtocolServiceImpl(TransferProcessStore transferProcessStore, TransactionContext transactionContext, ContractNegotiationStore negotiationStore, ContractValidationService contractValidationService, DataAddressValidator dataAddressValidator, TransferProcessObservable observable, Clock clock, Monitor monitor, Telemetry telemetry) {
        this.transferProcessStore = transferProcessStore;
        this.transactionContext = transactionContext;
        this.negotiationStore = negotiationStore;
        this.contractValidationService = contractValidationService;
        this.dataAddressValidator = dataAddressValidator;
        this.observable = observable;
        this.clock = clock;
        this.monitor = monitor;
        this.telemetry = telemetry;
    }

    @WithSpan
    @NotNull
    public ServiceResult<TransferProcess> notifyRequested(TransferRequestMessage message, ClaimToken claimToken) {
        Result validDestination;
        DataAddress destination = message.getDataDestination();
        if (destination != null && (validDestination = this.dataAddressValidator.validate(destination)).failed()) {
            return ServiceResult.badRequest((List)validDestination.getFailureMessages());
        }
        return (ServiceResult)this.transactionContext.execute(() -> Optional.ofNullable(this.negotiationStore.findContractAgreement(message.getContractId())).filter(agreement -> this.contractValidationService.validateAgreement(claimToken, agreement).succeeded()).map(agreement -> this.requestedAction(message, agreement.getAssetId())).orElse(ServiceResult.conflict((String)String.format("Cannot process %s because %s", message.getClass().getSimpleName(), "agreement not found or not valid"))));
    }

    @WithSpan
    @NotNull
    public ServiceResult<TransferProcess> notifyStarted(TransferStartMessage message, ClaimToken claimToken) {
        return this.onMessageDo((TransferRemoteMessage)message, claimToken, transferProcess -> this.startedAction(message, (TransferProcess)transferProcess));
    }

    @WithSpan
    @NotNull
    public ServiceResult<TransferProcess> notifyCompleted(TransferCompletionMessage message, ClaimToken claimToken) {
        return this.onMessageDo((TransferRemoteMessage)message, claimToken, transferProcess -> this.completedAction(message, (TransferProcess)transferProcess));
    }

    @WithSpan
    @NotNull
    public ServiceResult<TransferProcess> notifyTerminated(TransferTerminationMessage message, ClaimToken claimToken) {
        return this.onMessageDo((TransferRemoteMessage)message, claimToken, transferProcess -> this.terminatedAction(message, (TransferProcess)transferProcess));
    }

    @WithSpan
    @NotNull
    public ServiceResult<TransferProcess> findById(String id, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> Optional.ofNullable((TransferProcess)this.transferProcessStore.findById(id)).map(tp -> this.validateCounterParty(claimToken, (TransferProcess)tp)).orElse(this.notFound(id)));
    }

    @NotNull
    private ServiceResult<TransferProcess> requestedAction(TransferRequestMessage message, String assetId) {
        DataAddress destination = message.getDataDestination() != null ? message.getDataDestination() : DataAddress.Builder.newInstance().type("HttpProxy").build();
        DataRequest dataRequest = DataRequest.Builder.newInstance().id(message.getProcessId()).protocol(message.getProtocol()).connectorAddress(message.getCallbackAddress()).dataDestination(destination).assetId(assetId).contractId(message.getContractId()).build();
        TransferProcess existingTransferProcess = this.transferProcessStore.findForCorrelationId(dataRequest.getId());
        if (existingTransferProcess != null) {
            return ServiceResult.success((Object)existingTransferProcess);
        }
        TransferProcess process = ((TransferProcess.Builder)((TransferProcess.Builder)((TransferProcess.Builder)TransferProcess.Builder.newInstance().id(UUID.randomUUID().toString())).dataRequest(dataRequest).type(TransferProcess.Type.PROVIDER).clock(this.clock)).traceContext(this.telemetry.getCurrentTraceContext())).build();
        this.observable.invokeForEach(l -> l.preCreated(process));
        this.update(process);
        this.observable.invokeForEach(l -> l.initiated(process));
        return ServiceResult.success((Object)process);
    }

    @NotNull
    private ServiceResult<TransferProcess> startedAction(TransferStartMessage message, TransferProcess transferProcess) {
        if (transferProcess.getType() == TransferProcess.Type.CONSUMER && transferProcess.canBeStartedConsumer()) {
            this.observable.invokeForEach(l -> l.preStarted(transferProcess));
            transferProcess.transitionStarted();
            this.update(transferProcess);
            TransferProcessStartedData transferStartedData = TransferProcessStartedData.Builder.newInstance().dataAddress(message.getDataAddress()).build();
            this.observable.invokeForEach(l -> l.started(transferProcess, transferStartedData));
            return ServiceResult.success((Object)transferProcess);
        }
        return ServiceResult.conflict((String)String.format("Cannot process %s because %s", message.getClass().getSimpleName(), "transfer cannot be started"));
    }

    @NotNull
    private ServiceResult<TransferProcess> completedAction(TransferCompletionMessage message, TransferProcess transferProcess) {
        if (transferProcess.canBeCompleted()) {
            this.observable.invokeForEach(l -> l.preCompleted(transferProcess));
            transferProcess.transitionCompleted();
            this.update(transferProcess);
            this.observable.invokeForEach(l -> l.completed(transferProcess));
            return ServiceResult.success((Object)transferProcess);
        }
        return ServiceResult.conflict((String)String.format("Cannot process %s because %s", message.getClass().getSimpleName(), "transfer cannot be completed"));
    }

    @NotNull
    private ServiceResult<TransferProcess> terminatedAction(TransferTerminationMessage message, TransferProcess transferProcess) {
        if (transferProcess.canBeTerminated()) {
            this.observable.invokeForEach(l -> l.preTerminated(transferProcess));
            transferProcess.transitionTerminated();
            this.update(transferProcess);
            this.observable.invokeForEach(l -> l.terminated(transferProcess));
            return ServiceResult.success((Object)transferProcess);
        }
        return ServiceResult.conflict((String)String.format("Cannot process %s because %s", message.getClass().getSimpleName(), "transfer cannot be terminated"));
    }

    private ServiceResult<TransferProcess> onMessageDo(TransferRemoteMessage message, ClaimToken claimToken, Function<TransferProcess, ServiceResult<TransferProcess>> action) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.transferProcessStore.findByCorrelationIdAndLease(message.getProcessId()).flatMap(ServiceResult::from)).compose(transferProcess -> (ServiceResult)((ServiceResult)this.validateCounterParty(claimToken, (TransferProcess)transferProcess).compose(action)).onFailure(f -> this.breakLease((TransferProcess)transferProcess))));
    }

    private ServiceResult<TransferProcess> validateCounterParty(ClaimToken claimToken, TransferProcess transferProcess) {
        return Optional.ofNullable(this.negotiationStore.findContractAgreement(transferProcess.getContractId())).map(agreement -> this.contractValidationService.validateRequest(claimToken, agreement)).filter(AbstractResult::succeeded).map(e -> ServiceResult.success((Object)transferProcess)).orElse(this.notFound(transferProcess.getId()));
    }

    private ServiceResult<TransferProcess> notFound(String transferProcessId) {
        return ServiceResult.notFound((String)String.format("No transfer process with id %s found", transferProcessId));
    }

    private void breakLease(TransferProcess process) {
        this.transferProcessStore.save((Object)process);
    }

    private void update(TransferProcess transferProcess) {
        this.transferProcessStore.save((Object)transferProcess);
        this.monitor.debug(String.format("TransferProcess %s is now in state %s", transferProcess.getId(), TransferProcessStates.from((int)transferProcess.getState())), new Throwable[0]);
    }
}

