/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.policydefinition;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.edc.connector.contract.spi.offer.store.ContractDefinitionStore;
import org.eclipse.edc.connector.policy.spi.PolicyDefinition;
import org.eclipse.edc.connector.policy.spi.observe.PolicyDefinitionObservable;
import org.eclipse.edc.connector.policy.spi.store.PolicyDefinitionStore;
import org.eclipse.edc.connector.service.query.QueryValidator;
import org.eclipse.edc.connector.spi.policydefinition.PolicyDefinitionService;
import org.eclipse.edc.policy.model.AndConstraint;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.Constraint;
import org.eclipse.edc.policy.model.Expression;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.policy.model.MultiplicityConstraint;
import org.eclipse.edc.policy.model.OrConstraint;
import org.eclipse.edc.policy.model.XoneConstraint;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class PolicyDefinitionServiceImpl
implements PolicyDefinitionService {
    private final TransactionContext transactionContext;
    private final PolicyDefinitionStore policyStore;
    private final ContractDefinitionStore contractDefinitionStore;
    private final PolicyDefinitionObservable observable;
    private final QueryValidator queryValidator;

    public PolicyDefinitionServiceImpl(TransactionContext transactionContext, PolicyDefinitionStore policyStore, ContractDefinitionStore contractDefinitionStore, PolicyDefinitionObservable observable) {
        this.transactionContext = transactionContext;
        this.policyStore = policyStore;
        this.contractDefinitionStore = contractDefinitionStore;
        this.observable = observable;
        this.queryValidator = new QueryValidator(PolicyDefinition.class, this.getSubtypeMap());
    }

    public PolicyDefinition findById(String policyId) {
        return (PolicyDefinition)this.transactionContext.execute(() -> this.policyStore.findById(policyId));
    }

    public ServiceResult<Stream<PolicyDefinition>> query(QuerySpec query) {
        Result<Void> result = this.queryValidator.validate(query);
        if (result.failed()) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", result.getFailureDetail())});
        }
        return ServiceResult.success((Object)((Stream)this.transactionContext.execute(() -> this.policyStore.findAll(query))));
    }

    @NotNull
    public ServiceResult<PolicyDefinition> deleteById(String policyId) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            Criterion contractFilter = Criterion.criterion((Object)"contractPolicyId", (String)"=", (Object)policyId);
            Criterion accessFilter = Criterion.criterion((Object)"accessPolicyId", (String)"=", (Object)policyId);
            QuerySpec queryContractPolicyFilter = QuerySpec.Builder.newInstance().filter(contractFilter).build();
            try (Stream contractDefinitionOnPolicy = this.contractDefinitionStore.findAll(queryContractPolicyFilter);){
                if (contractDefinitionOnPolicy.findAny().isPresent()) {
                    ServiceResult serviceResult = ServiceResult.conflict((String)String.format("PolicyDefinition %s cannot be deleted as it is referenced by at least one contract definition", policyId));
                    return serviceResult;
                }
            }
            QuerySpec queryAccessPolicyFilter = QuerySpec.Builder.newInstance().filter(accessFilter).build();
            try (Stream accessDefinitionOnPolicy = this.contractDefinitionStore.findAll(queryAccessPolicyFilter);){
                if (accessDefinitionOnPolicy.findAny().isPresent()) {
                    ServiceResult serviceResult = ServiceResult.conflict((String)String.format("PolicyDefinition %s cannot be deleted as it is referenced by at least one contract definition", policyId));
                    return serviceResult;
                }
            }
            StoreResult deleted = this.policyStore.delete(policyId);
            deleted.onSuccess(pd -> this.observable.invokeForEach(l -> l.deleted(pd)));
            return ServiceResult.from((StoreResult)deleted);
        });
    }

    @NotNull
    public ServiceResult<PolicyDefinition> create(PolicyDefinition policyDefinition) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult saveResult = this.policyStore.create(policyDefinition);
            saveResult.onSuccess(v -> this.observable.invokeForEach(l -> l.created(policyDefinition)));
            return ServiceResult.from((StoreResult)saveResult);
        });
    }

    public ServiceResult<PolicyDefinition> update(PolicyDefinition policyDefinition) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult updateResult = this.policyStore.update(policyDefinition);
            updateResult.onSuccess(p -> this.observable.invokeForEach(l -> l.updated(p)));
            return ServiceResult.from((StoreResult)updateResult);
        });
    }

    private Map<Class<?>, List<Class<?>>> getSubtypeMap() {
        return Map.of(Constraint.class, List.of(MultiplicityConstraint.class, AtomicConstraint.class), MultiplicityConstraint.class, List.of(AndConstraint.class, OrConstraint.class, XoneConstraint.class), Expression.class, List.of(LiteralExpression.class));
    }
}

