/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.dataaddress;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.edc.spi.dataaddress.DataAddressValidator;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.HttpDataAddress;
import org.jetbrains.annotations.NotNull;

public class DataAddressValidatorImpl
implements DataAddressValidator {
    public Result<Void> validate(DataAddress dataAddress) {
        if ("HttpData".equals(dataAddress.getType())) {
            return this.validateHttpDataAddress(dataAddress);
        }
        return Result.success();
    }

    @NotNull
    private Result<Void> validateHttpDataAddress(DataAddress dataAddress) {
        HttpDataAddress httpDataAddress = ((HttpDataAddress.Builder)HttpDataAddress.Builder.newInstance().properties(dataAddress.getProperties())).build();
        String baseUrl = httpDataAddress.getBaseUrl();
        try {
            new URL(baseUrl);
            return Result.success();
        }
        catch (MalformedURLException e) {
            return Result.failure((String)String.format("DataAddress of type %s must contain a valid baseUrl: %s", "HttpData", baseUrl));
        }
    }
}

