/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.contractnegotiation;

import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.edc.connector.contract.spi.negotiation.observe.ContractNegotiationObservable;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.contract.spi.types.protocol.ContractRemoteMessage;
import org.eclipse.edc.connector.contract.spi.validation.ContractValidationService;
import org.eclipse.edc.connector.contract.spi.validation.ValidatedConsumerOffer;
import org.eclipse.edc.connector.spi.contractnegotiation.ContractNegotiationProtocolService;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.telemetry.Telemetry;
import org.eclipse.edc.transaction.spi.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class ContractNegotiationProtocolServiceImpl
implements ContractNegotiationProtocolService {
    private final ContractNegotiationStore store;
    private final TransactionContext transactionContext;
    private final ContractValidationService validationService;
    private final ContractNegotiationObservable observable;
    private final Monitor monitor;
    private final Telemetry telemetry;

    public ContractNegotiationProtocolServiceImpl(ContractNegotiationStore store, TransactionContext transactionContext, ContractValidationService validationService, ContractNegotiationObservable observable, Monitor monitor, Telemetry telemetry) {
        this.store = store;
        this.transactionContext = transactionContext;
        this.validationService = validationService;
        this.observable = observable;
        this.monitor = monitor;
        this.telemetry = telemetry;
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyRequested(ContractRequestMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.validateOffer(message, claimToken).compose(validatedOffer -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).recover(f -> this.createNegotiation(message, (ValidatedConsumerOffer)validatedOffer))).onSuccess(n -> n.addContractOffer(validatedOffer.getOffer())))).onSuccess(negotiation -> {
            negotiation.transitionRequested();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.requested(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyOffered(ContractOfferMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).compose(negotiation -> this.validateRequest(claimToken, (ContractNegotiation)negotiation))).onSuccess(negotiation -> {
            negotiation.addContractOffer(message.getContractOffer());
            negotiation.transitionOffered();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.offered(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyAccepted(ContractNegotiationEventMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).compose(negotiation -> this.validateRequest(claimToken, (ContractNegotiation)negotiation))).onSuccess(negotiation -> {
            negotiation.transitionAccepted();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.accepted(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyAgreed(ContractAgreementMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).compose(negotiation -> this.validateAgreed(message, claimToken, (ContractNegotiation)negotiation))).onSuccess(negotiation -> {
            negotiation.setContractAgreement(message.getContractAgreement());
            negotiation.transitionAgreed();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.agreed(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyVerified(ContractAgreementVerificationMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).compose(negotiation -> this.validateRequest(claimToken, (ContractNegotiation)negotiation))).onSuccess(negotiation -> {
            negotiation.transitionVerified();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.verified(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyFinalized(ContractNegotiationEventMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).compose(negotiation -> this.validateRequest(claimToken, (ContractNegotiation)negotiation))).onSuccess(negotiation -> {
            negotiation.transitionFinalized();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.finalized(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> notifyTerminated(ContractNegotiationTerminationMessage message, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> (ServiceResult)((ServiceResult)this.getNegotiation((ContractRemoteMessage)message).compose(negotiation -> this.validateRequest(claimToken, (ContractNegotiation)negotiation))).onSuccess(negotiation -> {
            negotiation.transitionTerminated();
            this.update((ContractNegotiation)negotiation);
            this.observable.invokeForEach(l -> l.terminated(negotiation));
        }));
    }

    @WithSpan
    @NotNull
    public ServiceResult<ContractNegotiation> findById(String id, ClaimToken claimToken) {
        return (ServiceResult)this.transactionContext.execute(() -> Optional.ofNullable((ContractNegotiation)this.store.findById(id)).map(negotiation -> this.validateRequest(claimToken, (ContractNegotiation)negotiation)).orElse(ServiceResult.notFound((String)"No negotiation with id %s found".formatted(id))));
    }

    @NotNull
    private ServiceResult<ContractNegotiation> createNegotiation(ContractRequestMessage message, ValidatedConsumerOffer validatedOffer) {
        ContractNegotiation negotiation = ((ContractNegotiation.Builder)((ContractNegotiation.Builder)ContractNegotiation.Builder.newInstance().id(UUID.randomUUID().toString())).correlationId(message.getProcessId()).counterPartyId(validatedOffer.getConsumerIdentity()).counterPartyAddress(message.getCallbackAddress()).protocol(message.getProtocol()).traceContext(this.telemetry.getCurrentTraceContext())).type(ContractNegotiation.Type.PROVIDER).build();
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ValidatedConsumerOffer> validateOffer(ContractRequestMessage message, ClaimToken claimToken) {
        Result result;
        Result result2 = result = message.getContractOffer() != null ? this.validationService.validateInitialOffer(claimToken, message.getContractOffer()) : this.validationService.validateInitialOffer(claimToken, message.getContractOfferId());
        if (result.failed()) {
            this.monitor.debug("[Provider] Contract offer rejected as invalid: " + result.getFailureDetail(), new Throwable[0]);
            return ServiceResult.badRequest((String[])new String[]{"Contract offer is not valid: " + result.getFailureDetail()});
        }
        return ServiceResult.success((Object)((ValidatedConsumerOffer)result.getContent()));
    }

    @NotNull
    private ServiceResult<ContractNegotiation> validateAgreed(ContractAgreementMessage message, ClaimToken claimToken, ContractNegotiation negotiation) {
        ContractAgreement agreement = message.getContractAgreement();
        Result result = this.validationService.validateConfirmed(claimToken, agreement, negotiation.getLastContractOffer());
        if (result.failed()) {
            String msg = "Contract agreement received. Validation failed: " + result.getFailureDetail();
            this.monitor.debug("[Consumer] " + msg, new Throwable[0]);
            return ServiceResult.badRequest((String[])new String[]{msg});
        }
        return ServiceResult.success((Object)negotiation);
    }

    @NotNull
    private ServiceResult<ContractNegotiation> validateRequest(ClaimToken claimToken, ContractNegotiation negotiation) {
        Result result = this.validationService.validateRequest(claimToken, negotiation);
        if (result.failed()) {
            return ServiceResult.badRequest((String[])new String[]{"Invalid client credentials: " + result.getFailureDetail()});
        }
        return ServiceResult.success((Object)negotiation);
    }

    private ServiceResult<ContractNegotiation> getNegotiation(ContractRemoteMessage message) {
        return (ServiceResult)this.store.findByCorrelationIdAndLease(message.getProcessId()).flatMap(ServiceResult::from);
    }

    private void update(ContractNegotiation negotiation) {
        this.store.save((Object)negotiation);
        this.monitor.debug(() -> "[%s] ContractNegotiation %s is now in state %s.".formatted(negotiation.getType(), negotiation.getId(), negotiation.stateAsString()), new Throwable[0]);
    }
}

