/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.contractdefinition;

import java.util.stream.Stream;
import org.eclipse.edc.connector.contract.spi.definition.observe.ContractDefinitionObservable;
import org.eclipse.edc.connector.contract.spi.offer.store.ContractDefinitionStore;
import org.eclipse.edc.connector.contract.spi.types.offer.ContractDefinition;
import org.eclipse.edc.connector.service.query.QueryValidator;
import org.eclipse.edc.connector.spi.contractdefinition.ContractDefinitionService;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.StoreResult;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class ContractDefinitionServiceImpl
implements ContractDefinitionService {
    private final ContractDefinitionStore store;
    private final TransactionContext transactionContext;
    private final ContractDefinitionObservable observable;
    private final QueryValidator queryValidator;

    public ContractDefinitionServiceImpl(ContractDefinitionStore store, TransactionContext transactionContext, ContractDefinitionObservable observable) {
        this.store = store;
        this.transactionContext = transactionContext;
        this.observable = observable;
        this.queryValidator = new QueryValidator(ContractDefinition.class);
    }

    public ContractDefinition findById(String contractDefinitionId) {
        return (ContractDefinition)this.transactionContext.execute(() -> this.store.findById(contractDefinitionId));
    }

    public ServiceResult<Stream<ContractDefinition>> query(QuerySpec query) {
        Result<Void> result = this.queryValidator.validate(query);
        if (result.failed()) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", result.getFailureDetail())});
        }
        return ServiceResult.success((Object)((Stream)this.transactionContext.execute(() -> this.store.findAll(query))));
    }

    public ServiceResult<ContractDefinition> create(ContractDefinition contractDefinition) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult saveResult = this.store.save(contractDefinition);
            if (saveResult.succeeded()) {
                this.observable.invokeForEach(l -> l.created(contractDefinition));
                return ServiceResult.success((Object)contractDefinition);
            }
            return ServiceResult.fromFailure((StoreResult)saveResult);
        });
    }

    public ServiceResult<Void> update(ContractDefinition contractDefinition) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult updateResult = this.store.update(contractDefinition);
            ServiceResult serviceResult = ServiceResult.from((StoreResult)updateResult);
            serviceResult.onSuccess(a -> this.observable.invokeForEach(l -> l.updated(contractDefinition)));
            return serviceResult;
        });
    }

    public ServiceResult<ContractDefinition> delete(String contractDefinitionId) {
        return (ServiceResult)this.transactionContext.execute(() -> {
            StoreResult deleteResult = this.store.deleteById(contractDefinitionId);
            ServiceResult serviceResult = ServiceResult.from((StoreResult)deleteResult);
            serviceResult.onSuccess(deleted -> this.observable.invokeForEach(l -> l.deleted(deleted)));
            return serviceResult;
        });
    }
}

