/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.contractagreement;

import java.util.stream.Stream;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.connector.contract.spi.types.negotiation.ContractNegotiation;
import org.eclipse.edc.connector.service.query.QueryValidator;
import org.eclipse.edc.connector.spi.contractagreement.ContractAgreementService;
import org.eclipse.edc.service.spi.result.ServiceResult;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class ContractAgreementServiceImpl
implements ContractAgreementService {
    private final ContractNegotiationStore store;
    private final TransactionContext transactionContext;
    private final QueryValidator queryValidator;

    public ContractAgreementServiceImpl(ContractNegotiationStore store, TransactionContext transactionContext) {
        this.store = store;
        this.transactionContext = transactionContext;
        this.queryValidator = new QueryValidator(ContractAgreement.class);
    }

    public ContractAgreement findById(String contractAgreementId) {
        return (ContractAgreement)this.transactionContext.execute(() -> this.store.findContractAgreement(contractAgreementId));
    }

    public ServiceResult<Stream<ContractAgreement>> query(QuerySpec query) {
        Result<Void> result = this.queryValidator.validate(query);
        if (result.failed()) {
            return ServiceResult.badRequest((String[])new String[]{String.format("Error validating schema: %s", result.getFailureDetail())});
        }
        return ServiceResult.success((Object)((Stream)this.transactionContext.execute(() -> this.store.queryAgreements(query))));
    }

    public ContractNegotiation findNegotiation(String contractAgreementId) {
        Criterion criterion = Criterion.criterion((Object)"contractAgreement.id", (String)"=", (Object)contractAgreementId);
        QuerySpec query = QuerySpec.Builder.newInstance().filter(criterion).build();
        return (ContractNegotiation)this.transactionContext.execute(() -> this.store.queryNegotiations(query).findFirst().orElse(null));
    }
}

