/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.service.catalog;

import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.catalog.spi.CatalogRequestMessage;
import org.eclipse.edc.catalog.spi.DatasetRequestMessage;
import org.eclipse.edc.connector.spi.catalog.CatalogService;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;

public class CatalogServiceImpl
implements CatalogService {
    private final RemoteMessageDispatcherRegistry dispatcher;

    public CatalogServiceImpl(RemoteMessageDispatcherRegistry dispatcher) {
        this.dispatcher = dispatcher;
    }

    public CompletableFuture<StatusResult<byte[]>> requestCatalog(String providerUrl, String protocol, QuerySpec querySpec) {
        CatalogRequestMessage request = CatalogRequestMessage.Builder.newInstance().protocol(protocol).counterPartyAddress(providerUrl).querySpec(querySpec).build();
        return this.dispatcher.dispatch(byte[].class, (RemoteMessage)request);
    }

    public CompletableFuture<StatusResult<byte[]>> requestDataset(String id, String counterPartyAddress, String protocol) {
        DatasetRequestMessage request = DatasetRequestMessage.Builder.newInstance().datasetId(id).protocol(protocol).counterPartyAddress(counterPartyAddress).build();
        return this.dispatcher.dispatch(byte[].class, (RemoteMessage)request);
    }
}

